/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.ChecksHelper;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="FileComplexity", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FileComplexityCheck
extends SquidCheck<PythonGrammar> {
    private static final int DEFAULT_MAXIMUM_FILE_COMPLEXITY_THRESHOLD = 80;
    @RuleProperty(key="maximumFileComplexityThreshold", defaultValue="80")
    private int maximumFileComplexityThreshold = 80;

    public void leaveFile(AstNode astNode) {
        SourceFile sourceFile = (SourceFile)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceFile, (MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumFileComplexityThreshold) {
            this.getContext().createFileViolation((CodeCheck)this, "File has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", new Object[]{complexity, this.maximumFileComplexityThreshold});
        }
    }

    public void setMaximumFileComplexityThreshold(int threshold) {
        this.maximumFileComplexityThreshold = threshold;
    }
}

