/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonMetric;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FileComplexity", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FileComplexityCheck
extends SquidCheck<Grammar> {
    private static final int DEFAULT_MAXIMUM_FILE_COMPLEXITY_THRESHOLD = 80;
    @RuleProperty(key="maximumFileComplexityThreshold", defaultValue="80")
    private int maximumFileComplexityThreshold = 80;

    public void leaveFile(AstNode astNode) {
        SourceFile sourceFile = (SourceFile)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceFile, (MetricDef)PythonMetric.COMPLEXITY);
        if (complexity > this.maximumFileComplexityThreshold) {
            this.getContext().createFileViolation((CodeCheck)this, "File has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", new Object[]{complexity, this.maximumFileComplexityThreshold});
        }
    }

    public void setMaximumFileComplexityThreshold(int threshold) {
        this.maximumFileComplexityThreshold = threshold;
    }
}

