/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="OneStatementPerLine", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class OneStatementPerLineCheck
extends SquidCheck<Grammar> {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.SIMPLE_STMT, PythonGrammar.SUITE});
    }

    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    public void visitNode(AstNode statementNode) {
        int line = statementNode.getTokenLine();
        if (!this.statementsPerLine.containsKey(line)) {
            this.statementsPerLine.put(line, 0);
        }
        this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
    }

    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            this.getContext().createLineViolation((CodeCheck)this, "At most one statement is allowed per line, but {0} statements were found on this line.", statementsAtLine.getKey().intValue(), new Object[]{statementsAtLine.getValue()});
        }
    }
}

