/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.base.Predicate;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S108", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class EmptyNestedBlockCheck
extends SquidCheck<Grammar> {
    private static final Predicate<AstNode> NOT_PASS_PREDICATE = new NotPassPredicate();
    private static final String MESSAGE = "Either remove or fill this block of code.";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.SUITE});
    }

    public void visitNode(AstNode suiteNode) {
        AstSelect nonPassSimpleStatements;
        if (suiteNode.getParent().is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF}) || this.isInExcept(suiteNode)) {
            return;
        }
        AstSelect suite = suiteNode.select();
        AstSelect stmtLists = suite.children((AstNodeType)PythonGrammar.STMT_LIST);
        if (stmtLists.isEmpty()) {
            AstSelect statementSelect = suite.children((AstNodeType)PythonGrammar.STATEMENT);
            if (statementSelect.children((AstNodeType)PythonGrammar.COMPOUND_STMT).isNotEmpty()) {
                return;
            }
            stmtLists = statementSelect.children((AstNodeType)PythonGrammar.STMT_LIST);
        }
        if ((nonPassSimpleStatements = stmtLists.children((AstNodeType)PythonGrammar.SIMPLE_STMT).children().filter(NOT_PASS_PREDICATE)).isEmpty() && !this.containsComment(suiteNode)) {
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, stmtLists.get(0), new Object[0]);
        }
    }

    private boolean isInExcept(AstNode suiteNode) {
        return suiteNode.getParent().is(new AstNodeType[]{PythonGrammar.TRY_STMT}) && suiteNode.getPreviousSibling().getPreviousSibling().is(new AstNodeType[]{PythonGrammar.EXCEPT_CLAUSE});
    }

    private boolean containsComment(AstNode suiteNode) {
        for (Token token : suiteNode.getTokens()) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment()) continue;
                return true;
            }
        }
        return false;
    }

    private static class NotPassPredicate
    implements Predicate<AstNode> {
        private NotPassPredicate() {
        }

        public boolean apply(AstNode node) {
            return node.getType() != PythonGrammar.PASS_STMT;
        }
    }
}

