/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="LongIntegerWithLowercaseSuffixUsage", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LongIntegerWithLowercaseSuffixUsageCheck
extends SquidCheck<Grammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonTokenType.NUMBER});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.charAt(value.length() - 1) == 'l') {
            this.getContext().createLineViolation((CodeCheck)this, "Replace suffix in long integers from lower case \"l\" to upper case \"L\".", astNode, new Object[0]);
        }
    }
}

