/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S134", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NestedControlFlowDepthCheck
extends SquidCheck<Grammar> {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(key="max", defaultValue="3")
    public int max = 3;
    private int depth;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.IF_STMT, PythonGrammar.FOR_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.TRY_STMT, PythonGrammar.WITH_STMT});
    }

    public void visitFile(AstNode astNode) {
        this.depth = 0;
    }

    public void visitNode(AstNode node) {
        ++this.depth;
        if (this.depth == this.max + 1) {
            String message = "Refactor this code to not nest more than {0} \"if\", \"for\", \"while\", \"try\" and \"with\" statements.";
            this.getContext().createLineViolation((CodeCheck)this, message, node, new Object[]{this.max});
        }
    }

    public void leaveNode(AstNode astNode) {
        --this.depth;
    }
}

