/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="PrintStatementUsage", priority=Priority.MAJOR, name="The \"print\" statement should not be used", tags={"obsolete"})
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class PrintStatementUsageCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "PrintStatementUsage";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.PRINT_STMT});
    }

    public void visitNode(AstNode astNode) {
        this.getContext().createLineViolation((CodeCheck)this, "Replace print statement by built-in function.", astNode, new Object[0]);
    }
}

