/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="BackticksUsage", priority=Priority.MAJOR, name="Backticks should not be used")
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class BackticksUsageCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "BackticksUsage";
    private int prevLine = -1;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonPunctuator.BACKTICK});
    }

    public void visitNode(AstNode astNode) {
        if (this.prevLine != astNode.getTokenLine()) {
            this.prevLine = astNode.getTokenLine();
            this.getContext().createLineViolation((CodeCheck)this, "Use \"repr\" instead.", astNode, new Object[0]);
        }
    }
}

