/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1716", priority=Priority.MAJOR, name="\"break\" and \"continue\" should not be used outside a loop")
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class BreakContinueOutsideLoopCheck
extends SquidCheck<Grammar> {
    public static final String MESSAGE = "Remove this \"%s\" statement";
    public static final String CHECK_KEY = "S1716";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.BREAK_STMT, PythonGrammar.CONTINUE_STMT});
    }

    public void visitNode(AstNode node) {
        for (AstNode currentParent = node.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (currentParent.is(new AstNodeType[]{PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT})) {
                return;
            }
            if (!currentParent.is(new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF})) continue;
            this.raiseIssue(node);
            return;
        }
        this.raiseIssue(node);
    }

    private void raiseIssue(AstNode node) {
        this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE, node.getToken().getValue()), node, new Object[0]);
    }
}

