/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S2733", priority=Priority.CRITICAL, name="\"__exit__\" should accept type, value, and traceback arguments", tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class ExitHasBadArgumentsCheck
extends SquidCheck<Grammar> {
    public static final String MESSAGE_ADD = "Add the missing argument.";
    public static final String MESSAGE_REMOVE = "Remove the unnecessary argument.";
    private static final int EXIT_ARGUMENTS_NUMBER = 4;
    public static final String CHECK_KEY = "S2733";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        if (!"__exit__".equals(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getToken().getValue())) {
            return;
        }
        AstNode varArgList = node.getFirstChild(new AstNodeType[]{PythonGrammar.TYPEDARGSLIST});
        if (varArgList != null) {
            List arguments = varArgList.getChildren(new AstNodeType[]{PythonGrammar.TFPDEF});
            List starArguments = varArgList.getChildren(new AstNodeType[]{PythonGrammar.NAME});
            if (starArguments.size() == 1 && arguments.size() == 1) {
                return;
            }
            this.raiseIssue(node, arguments.size() + starArguments.size());
        } else {
            this.raiseIssue(node, 0);
        }
    }

    private void raiseIssue(AstNode node, int argumentsNumber) {
        if (argumentsNumber != 4) {
            String message = MESSAGE_ADD;
            if (argumentsNumber > 4) {
                message = MESSAGE_REMOVE;
            }
            this.getContext().createLineViolation((CodeCheck)this, message, node, new Object[0]);
        }
    }
}

