/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S2734", priority=Priority.CRITICAL, name="\"__init__\" should not return a value", tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class InitReturnsValueCheck
extends SquidCheck<Grammar> {
    public static final String MESSAGE_RETURN = "Remove this return value.";
    public static final String MESSAGE_YIELD = "Remove this yield statement.";
    public static final String CHECK_KEY = "S2734";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF});
    }

    public void visitNode(AstNode node) {
        if (!"__init__".equals(node.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getTokenValue())) {
            return;
        }
        List returnYieldStatements = node.getDescendants(new AstNodeType[]{PythonGrammar.YIELD_STMT, PythonGrammar.RETURN_STMT});
        for (AstNode returnYieldStatement : returnYieldStatements) {
            if (!CheckUtils.insideFunction(returnYieldStatement, node) || this.returnReturnNone(returnYieldStatement)) continue;
            this.raiseIssue(returnYieldStatement);
        }
    }

    private boolean returnReturnNone(AstNode stmt) {
        return stmt.is(new AstNodeType[]{PythonGrammar.RETURN_STMT}) && (stmt.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}) == null || stmt.getFirstChild(new AstNodeType[]{PythonGrammar.TESTLIST}).getToken().getValue().equals(PythonKeyword.NONE.getValue()));
    }

    private void raiseIssue(AstNode node) {
        String message = MESSAGE_RETURN;
        if (node.is(new AstNodeType[]{PythonGrammar.YIELD_STMT})) {
            message = MESSAGE_YIELD;
        }
        this.getContext().createLineViolation((CodeCheck)this, message, node, new Object[0]);
    }
}

