/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.checks.CheckUtils;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;

@Rule(key="S1862", priority=Priority.CRITICAL, name="Conditions in related \"if/elif/else if\" statements should not have the same condition", tags={"bug", "unused", "cert", "pitfall"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
@ActivatedByDefault
public class SameConditionCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1862";
    private List<AstNode> ignoreList;

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.IF_STMT});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.ignoreList = new LinkedList<AstNode>();
    }

    public void visitNode(AstNode node) {
        if (this.ignoreList.contains(node)) {
            return;
        }
        List<AstNode> conditions = this.getConditionsToCompare(node);
        this.findSameConditions(conditions);
    }

    private List<AstNode> getConditionsToCompare(AstNode ifStmt) {
        List conditions = ifStmt.getChildren(new AstNodeType[]{PythonGrammar.TEST});
        AstNode elseNode = ifStmt.getFirstChild(new AstNodeType[]{PythonKeyword.ELSE});
        if (conditions.size() == 1 && elseNode != null) {
            AstNode suite = elseNode.getNextSibling().getNextSibling();
            this.lookForElseIfs(conditions, suite);
        }
        return conditions;
    }

    private void lookForElseIfs(List<AstNode> conditions, AstNode suite) {
        AstNode singleIfChild = this.singleIfChild(suite);
        if (singleIfChild != null) {
            this.ignoreList.add(singleIfChild);
            conditions.addAll(this.getConditionsToCompare(singleIfChild));
        }
    }

    private void findSameConditions(List<AstNode> conditions) {
        for (int i = 1; i < conditions.size(); ++i) {
            this.checkCondition(conditions, i);
        }
    }

    private void checkCondition(List<AstNode> conditions, int index) {
        for (int j = 0; j < index; ++j) {
            if (!CheckUtils.equalNodes(conditions.get(j), conditions.get(index))) continue;
            String message = String.format("This branch duplicates the one on line %s.", conditions.get(j).getToken().getLine());
            this.getContext().createLineViolation((CodeCheck)this, message, conditions.get(index).getToken().getLine(), new Object[0]);
            return;
        }
    }

    private AstNode singleIfChild(AstNode suite) {
        AstSelect nestedIf;
        List statements = suite.getChildren(new AstNodeType[]{PythonGrammar.STATEMENT});
        if (statements.size() == 1 && (nestedIf = ((AstNode)statements.get(0)).select().children((AstNodeType)PythonGrammar.COMPOUND_STMT).children((AstNodeType)PythonGrammar.IF_STMT)).size() == 1) {
            return nestedIf.get(0);
        }
        return null;
    }
}

