/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.CharsetAwareVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1131", priority=Priority.MINOR, name="Lines should not end with trailing whitespaces", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingWhitespaceCheck
extends SquidCheck<Grammar>
implements CharsetAwareVisitor {
    public static final String CHECK_KEY = "S1131";
    public static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(@Nullable AstNode astNode) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read " + this.getContext().getFile(), e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (!((String)lines.get(i)).matches(".*\\s$")) continue;
            this.getContext().createLineViolation((CodeCheck)this, MESSAGE, i + 1, new Object[0]);
        }
    }
}

