/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import com.sonar.sslr.impl.matcher.MatcherTreePrinter;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedStackTraceStream {
    private static final int STACK_TRACE_RULE_STARTING_WITH_TOKENS = 4;
    private static final int SOURCE_CODE_TOKENS_WINDOW = 30;
    private static final int LINE_AND_COLUMN_LEFT_PAD_LENGTH = 6;
    private static final int LAST_SUCCESSFUL_TOKENS_WINDOW = 7;

    private ExtendedStackTraceStream() {
    }

    public static void print(ExtendedStackTrace extendedStackTrace, PrintStream stream) {
        stream.println("Source Snippet:");
        stream.println("---------------");
        ExtendedStackTraceStream.displaySourceSnippet(extendedStackTrace, stream);
        stream.println("---------------");
        stream.println();
        ExtendedStackTraceStream.displayStackTrace(extendedStackTrace, stream);
        stream.println();
        stream.println("Last successful tokens:");
        stream.println("-----------------------");
        ExtendedStackTraceStream.displayLastSuccessfulTokens(extendedStackTrace, stream);
    }

    private static void displaySourceSnippet(ExtendedStackTrace extendedStackTrace, PrintStream stream) {
        Token failedToken = extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex);
        List<Token> tokens = ExtendedStackTraceStream.getTokensToDisplayAroundOutpostMatcherToken(extendedStackTrace);
        int previousLine = 0;
        StringBuilder lineBuilder = new StringBuilder();
        for (Token token : tokens) {
            int currentLine = token.getLine();
            if (currentLine != previousLine) {
                if (previousLine != 0) {
                    stream.println(lineBuilder.toString());
                }
                lineBuilder = new StringBuilder();
                if (++previousLine != 1) {
                    while (previousLine < currentLine) {
                        ExtendedStackTraceStream.displaySourceCodeLineHeader(lineBuilder, previousLine, failedToken.getLine());
                        lineBuilder.append(System.getProperty("line.separator"));
                        ++previousLine;
                    }
                } else {
                    previousLine = currentLine;
                }
                stream.print(lineBuilder.toString());
                lineBuilder = new StringBuilder();
                ExtendedStackTraceStream.displaySourceCodeLineHeader(lineBuilder, token.getLine(), failedToken.getLine());
            }
            previousLine = ExtendedStackTraceStream.displayToken(lineBuilder, token, failedToken.getLine());
        }
        if (!tokens.isEmpty()) {
            stream.println(lineBuilder.toString());
        }
    }

    private static List<Token> getTokensToDisplayAroundOutpostMatcherToken(ExtendedStackTrace extendedStackTrace) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int outpostMatcherTokenIndex = extendedStackTrace.longestIndex + 1;
        for (int i = outpostMatcherTokenIndex - 30; i <= outpostMatcherTokenIndex + 30; ++i) {
            if (i < 0 || i > extendedStackTrace.longestParsingState.lexerSize - 1) continue;
            tokens.add(extendedStackTrace.longestParsingState.readToken(i));
        }
        return tokens;
    }

    private static void displaySourceCodeLineHeader(StringBuilder lineBuilder, int currentLine, int parsingErrorLine) {
        String line = parsingErrorLine == currentLine ? "-->" : Integer.toString(currentLine);
        for (int i = 0; i < 6 - line.length() - 1; ++i) {
            lineBuilder.append(" ");
        }
        lineBuilder.append(line);
        lineBuilder.append(" ");
    }

    private static int displayToken(StringBuilder lineBuilder, Token token, int parsingErrorLine) {
        int currentLine = token.getLine();
        String[] tokenLines = token.getValue().replace("\r", "").split("\n", -1);
        while (lineBuilder.length() - 6 < token.getColumn()) {
            lineBuilder.append(" ");
        }
        lineBuilder.append(tokenLines[0]);
        for (int i = 1; i < tokenLines.length; ++i) {
            lineBuilder.append(System.getProperty("line.separator"));
            ExtendedStackTraceStream.displaySourceCodeLineHeader(lineBuilder, ++currentLine, parsingErrorLine);
            lineBuilder.append(tokenLines[i]);
        }
        return currentLine;
    }

    private static void displayStackTrace(ExtendedStackTrace extendedStackTrace, PrintStream stream) {
        if (extendedStackTrace.longestStack.size() == 0) {
            stream.println("[ Not a single match ]");
        } else {
            stream.println("on matcher " + MatcherTreePrinter.print(extendedStackTrace.longestOutertMatcher));
            stream.print(ExtendedStackTraceStream.getPosition(extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex).getLine(), extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex).getColumn()));
            stream.print(MatcherTreePrinter.print(extendedStackTrace.longestMatcher) + " expected but ");
            stream.println("\"" + extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex).getValue().replace("\"", "\\\"") + "\"" + " [" + extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex).getType() + "] found");
            for (int i = extendedStackTrace.longestStack.size() - 1; i >= 0; --i) {
                stream.print("at ");
                ExtendedStackTraceStream.displayStackTraceRuleWithPosition(extendedStackTrace, stream, i);
            }
        }
    }

    private static String getPosition(int line, int column) {
        return "  " + String.format("%6d", line) + " : " + String.format("%6d", column) + "  : ";
    }

    private static void displayStackTraceRuleWithPosition(ExtendedStackTrace extendedStackTrace, PrintStream stream, int ruleWithPosition) {
        int i;
        StringBuilder ruleBuilder = new StringBuilder();
        Token fromToken = extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestStack.getFromIndex(ruleWithPosition));
        ruleBuilder.append(extendedStackTrace.longestStack.getRule(ruleWithPosition).getName() + System.getProperty("line.separator"));
        ruleBuilder.append(ExtendedStackTraceStream.getPosition(fromToken.getLine(), fromToken.getColumn()));
        for (i = extendedStackTrace.longestStack.getFromIndex(ruleWithPosition); i < extendedStackTrace.longestStack.getFromIndex(ruleWithPosition) + 4 && i < extendedStackTrace.longestStack.getToIndex(ruleWithPosition) && i < extendedStackTrace.longestParsingState.lexerSize; ++i) {
            ruleBuilder.append(extendedStackTrace.longestParsingState.readToken(i).getValue());
            ruleBuilder.append(" ");
        }
        if (i < extendedStackTrace.longestStack.getToIndex(ruleWithPosition) && i < extendedStackTrace.longestParsingState.lexerSize) {
            ruleBuilder.append("...");
        }
        stream.println(ruleBuilder);
    }

    private static void displayLastSuccessfulTokens(ExtendedStackTrace extendedStackTrace, PrintStream stream) {
        for (int i = extendedStackTrace.longestIndex - 1; i >= extendedStackTrace.longestIndex - 7 && i >= 0; --i) {
            Token token = extendedStackTrace.longestParsingState.readToken(i);
            stream.println("  \"" + token.getValue().replace("\"", "\\\"") + "\" at " + token.getLine() + ":" + token.getColumn() + " consumed by " + ExtendedStackTraceStream.getTokenConsumer(extendedStackTrace, i).getName());
        }
    }

    private static RuleMatcher getTokenConsumer(ExtendedStackTrace extendedStackTrace, int lexerIndex) {
        for (int i = 0; i < extendedStackTrace.longestStack.size(); ++i) {
            if (extendedStackTrace.longestStack.getFromIndex(i) > lexerIndex || lexerIndex >= extendedStackTrace.longestStack.getToIndex(i)) continue;
            return extendedStackTrace.longestStack.getRule(i);
        }
        throw new IllegalStateException("No token consumer was found for lexerIndex = " + lexerIndex);
    }
}

