/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.ast.AlwaysSkipFromAst;
import com.sonar.sslr.impl.ast.NeverSkipFromAst;
import com.sonar.sslr.impl.ast.SkipFromAstIfOnlyOneChild;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;

public final class RuleDefinition
implements Rule,
AstNodeSkippingPolicy {
    private RuleMatcher ruleMatcher;
    private Object adapter;
    private AstNodeType astNodeSkippingPolicy = new NeverSkipFromAst();

    private RuleDefinition() {
    }

    public static RuleDefinition newRuleBuilder(String ruleName) {
        RuleDefinition ruleBuilder = new RuleDefinition();
        ruleBuilder.setRuleMatcher(new RuleMatcher(ruleName));
        return ruleBuilder;
    }

    public static RuleDefinition newRuleBuilder(RuleMatcher ruleMatcher) {
        RuleDefinition ruleBuilder = new RuleDefinition();
        ruleBuilder.setRuleMatcher(ruleMatcher);
        return ruleBuilder;
    }

    public RuleMatcher getRule() {
        return this.ruleMatcher;
    }

    public void setRuleMatcher(RuleMatcher ruleMatcher) {
        this.ruleMatcher = ruleMatcher;
        ruleMatcher.setNodeType(this);
    }

    public RuleDefinition is(Object ... matchers) {
        this.throwExceptionIfRuleAlreadyDefined("The rule '" + this.ruleMatcher + "' has already been defined somewhere in the grammar.");
        this.throwExceptionIfEmptyListOfMatchers(matchers);
        this.setMatcher(GrammarFunctions.Standard.and(matchers));
        return this;
    }

    public RuleDefinition override(Object ... matchers) {
        this.throwExceptionIfEmptyListOfMatchers(matchers);
        this.setMatcher(GrammarFunctions.Standard.and(matchers));
        return this;
    }

    public void mock() {
        this.setMatcher(GrammarFunctions.Standard.or(this.ruleMatcher.getName(), this.ruleMatcher.getName().toUpperCase()));
    }

    public void skip() {
        this.astNodeSkippingPolicy = new AlwaysSkipFromAst();
    }

    protected void setMatcher(Matcher matcher) {
        this.ruleMatcher.children = new Matcher[]{matcher};
    }

    public void skipIf(AstNodeSkippingPolicy astNodeSkipPolicy) {
        this.astNodeSkippingPolicy = astNodeSkipPolicy;
    }

    public void skipIfOneChild() {
        this.astNodeSkippingPolicy = new SkipFromAstIfOnlyOneChild();
    }

    public void plug(Object adapter) {
        this.adapter = adapter;
    }

    private void throwExceptionIfRuleAlreadyDefined(String exceptionMessage) {
        if (this.ruleMatcher.children.length != 0) {
            throw new IllegalStateException(exceptionMessage);
        }
    }

    private void throwExceptionIfEmptyListOfMatchers(Object[] matchers) {
        if (matchers.length == 0) {
            throw new IllegalStateException("The rule '" + this.ruleMatcher + "' should at least contains one matcher.");
        }
    }

    public Object getAdapter() {
        return this.adapter;
    }

    public void recoveryRule() {
        this.ruleMatcher.recoveryRule();
    }

    public String toString() {
        return this.ruleMatcher.getName();
    }

    public boolean hasToBeSkippedFromAst(AstNode node) {
        if (AstNodeSkippingPolicy.class.isAssignableFrom(this.astNodeSkippingPolicy.getClass())) {
            return ((AstNodeSkippingPolicy)this.astNodeSkippingPolicy).hasToBeSkippedFromAst(node);
        }
        return false;
    }
}

