/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.google.common.base.Objects;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.matcher.TokenMatcher;

public final class TokenTypeClassMatcher
extends TokenMatcher {
    private final Class typeClass;

    protected TokenTypeClassMatcher(Class typeClass) {
        super(false);
        this.typeClass = typeClass;
    }

    protected boolean isExpectedToken(Token token) {
        return this.typeClass == token.getType().getClass();
    }

    public String toString() {
        return this.typeClass.getCanonicalName() + ".class";
    }

    public int hashCode() {
        return Objects.hashCode(this.getClass(), this.typeClass);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TokenTypeClassMatcher other = (TokenTypeClassMatcher)obj;
        return Objects.equal(this.typeClass, other.typeClass);
    }
}

