/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentationChannel
extends Channel<Lexer> {
    private final StringBuilder buffer = new StringBuilder();
    private final LexerState lexerState;

    public IndentationChannel(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (this.lexerState.joined) {
            this.lexerState.joined = false;
            return false;
        }
        if (code.getColumnPosition() != 0) {
            return false;
        }
        int line = code.getLinePosition();
        int column = code.getColumnPosition();
        int index = 0;
        char ch = code.charAt(index);
        while (ch == ' ' || ch == '\t') {
            ch = code.charAt(++index);
        }
        if (ch == '\n' || ch == '\r' || ch == '#') {
            return false;
        }
        this.buffer.setLength(0);
        int indentationLevel = 0;
        for (int i = 0; i < index; ++i) {
            this.buffer.append((char)code.pop());
            ++indentationLevel;
        }
        if (indentationLevel > this.lexerState.indentationStack.peek()) {
            this.lexerState.indentationStack.push(indentationLevel);
            lexer.addToken(new Token[]{Token.builder().setType((TokenType)PythonTokenType.INDENT).setValueAndOriginalValue(this.buffer.toString()).setURI(lexer.getURI()).setLine(line).setColumn(column).build()});
        } else if (indentationLevel < this.lexerState.indentationStack.peek()) {
            while (indentationLevel < this.lexerState.indentationStack.peek()) {
                this.lexerState.indentationStack.pop();
                lexer.addToken(new Token[]{Token.builder().setType((TokenType)PythonTokenType.DEDENT).setValueAndOriginalValue(this.buffer.toString()).setURI(lexer.getURI()).setLine(line).setColumn(column).build()});
            }
        }
        return this.buffer.length() != 0;
    }
}

