/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.io.File;
import java.util.Collection;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.PythonLinesOfCodeVisitor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.parser.PythonParser;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SourceCodeBuilderCallback;
import org.sonar.squidbridge.SourceCodeBuilderVisitor;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.squidbridge.metrics.ComplexityVisitor;
import org.sonar.squidbridge.metrics.CounterVisitor;
import org.sonar.squidbridge.metrics.LinesVisitor;

public final class PythonAstScanner {
    private PythonAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<Grammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<Grammar> scanner = PythonAstScanner.create(new PythonConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection sources = scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<Grammar> create(PythonConfiguration conf, SquidAstVisitor<Grammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("Python Project"));
        Parser<Grammar> parser = PythonParser.create(conf);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])PythonMetric.values());
        builder.setFilesMetric((MetricDef)PythonMetric.FILES);
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.substring(comment.indexOf(35));
            }
        });
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.CLASSNAME}).getFirstChild().getTokenValue();
                SourceClass function = new SourceClass(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{PythonGrammar.CLASSDEF}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.CLASSES).subscribeTo(new AstNodeType[]{PythonGrammar.CLASSDEF}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getFirstChild(new AstNodeType[]{PythonGrammar.FUNCNAME}).getFirstChild().getTokenValue();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{PythonGrammar.FUNCDEF}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{PythonGrammar.FUNCDEF}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)PythonMetric.LINES));
        builder.withSquidAstVisitor(new PythonLinesOfCodeVisitor(PythonMetric.LINES_OF_CODE));
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{PythonGrammar.FUNCDEF, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.RETURN_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.EXCEPT_CLAUSE, PythonKeyword.IF, PythonKeyword.AND, PythonKeyword.OR};
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)PythonMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)PythonMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)PythonMetric.STATEMENTS).subscribeTo(new AstNodeType[]{PythonGrammar.STATEMENT}).build());
        for (SquidAstVisitor<Grammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

