/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.python.PythonAstScanner;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.checks.CheckList;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.indexer.QueryByParent;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PythonSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final AnnotationCheckFactory annotationCheckFactory;
    private Project project;
    private SensorContext context;
    private AstScanner<PythonGrammar> scanner;

    public PythonSquidSensor(RulesProfile profile) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"python", (Collection)CheckList.getChecks());
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "py".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        this.project = project;
        this.context = context;
        Collection squidChecks = this.annotationCheckFactory.getChecks();
        this.scanner = PythonAstScanner.create((PythonConfiguration)this.createConfiguration(project), (SquidAstVisitor[])((SquidAstVisitor[])squidChecks.toArray(new SquidCheck[squidChecks.size()])));
        this.scanner.scanFiles((Collection)InputFileUtils.toFiles((Collection)project.getFileSystem().mainFiles(new String[]{"py"})));
        Collection squidSourceFiles = this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)});
        this.save(squidSourceFiles);
    }

    private PythonConfiguration createConfiguration(Project project) {
        return new PythonConfiguration(project.getFileSystem().getSourceCharset());
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)new File(squidFile.getKey()), (Project)this.project);
            this.saveFilesComplexityDistribution(sonarFile, squidFile);
            this.saveFunctionsComplexityDistribution(sonarFile, squidFile);
            this.saveMeasures(sonarFile, squidFile);
            this.saveViolations(sonarFile, squidFile);
        }
    }

    private void saveMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FILES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FILES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_BLANK_LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMMENT_BLANK_LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)PythonMetric.COMMENT_LINES)));
    }

    private void saveFunctionsComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        for (SourceCode squidFunction : squidFunctionsInFile) {
            complexityDistribution.add((Number)squidFunction.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)PythonMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveViolations(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                Violation violation = Violation.create((ActiveRule)this.annotationCheckFactory.getActiveRule((Object)message.getChecker()), (Resource)sonarFile).setLineId(message.getLine()).setMessage(message.getText(Locale.ENGLISH));
                this.context.saveViolation(violation);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

