/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintConfiguration;
import org.sonar.plugins.python.pylint.PylintViolationsAnalyzer;

public class PylintSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PylintSensor.class);
    private RuleFinder ruleFinder;
    private RulesProfile profile;
    private PylintConfiguration conf;

    public PylintSensor(RuleFinder ruleFinder, PylintConfiguration conf, RulesProfile profile) {
        this.ruleFinder = ruleFinder;
        this.conf = conf;
        this.profile = profile;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "py".equals(project.getLanguageKey()) && !this.profile.getActiveRulesByRepository("Pylint").isEmpty();
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File workdir = new File(project.getFileSystem().getSonarWorkingDirectory(), "/pylint/");
        PylintSensor.prepareWorkDir(workdir);
        int i = 0;
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"py"})) {
            try {
                File out = new File(workdir, i + ".out");
                this.analyzeFile(inputFile, out, project, sensorContext);
                ++i;
            }
            catch (Exception e) {
                String msg = "Cannot analyse the file '" + inputFile.getFile().getAbsolutePath() + "', details: '" + e + "'";
                throw new SonarException(msg, (Throwable)e);
            }
        }
    }

    protected void analyzeFile(InputFile inputFile, File out, Project project, SensorContext sensorContext) throws IOException {
        org.sonar.api.resources.File pyfile = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
        String pylintConfigPath = this.conf.getPylintConfigPath(project);
        String pylintPath = this.conf.getPylintPath();
        PylintViolationsAnalyzer analyzer = new PylintViolationsAnalyzer(pylintPath, pylintConfigPath);
        List<Issue> issues = analyzer.analyze(inputFile.getFile().getPath(), project.getFileSystem().getSourceCharset(), out);
        for (Issue issue : issues) {
            Rule rule = this.ruleFinder.findByKey("Pylint", issue.ruleId);
            if (rule != null) {
                if (rule.isEnabled().booleanValue()) {
                    Violation violation = Violation.create((Rule)rule, (Resource)pyfile);
                    violation.setLineId(Integer.valueOf(issue.line));
                    violation.setMessage(issue.descr);
                    sensorContext.saveViolation(violation);
                    LOG.trace("Saved pylint violation: {}", (Object)issue);
                    continue;
                }
                LOG.debug("Pylint rule '{}' is disabled in Sonar", (Object)issue.ruleId);
                continue;
            }
            LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)issue.ruleId);
        }
    }

    private static void prepareWorkDir(File dir) {
        try {
            FileUtils.forceMkdir((File)dir);
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new SonarException("Cannot create directory: " + dir, (Throwable)e);
        }
    }
}

