/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PylintViolationsAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(PylintSensor.class);
    private static final Map<String, String> ID_MAP = new HashMap<String, String>(){
        {
            this.put("E9900", "E1300");
            this.put("E9901", "E1301");
            this.put("E9902", "E1302");
            this.put("E9903", "E1303");
            this.put("E9904", "E1304");
            this.put("E9905", "E1305");
            this.put("E9906", "E1306");
            this.put("W6501", "W1201");
            this.put("W9900", "W1300");
            this.put("W9901", "W1301");
        }
    };
    private static final String FALLBACK_PYLINT = "pylint";
    private static final String[] ARGS = new String[]{"-i", "y", "-f", "parseable", "-r", "n"};
    private static final Pattern PATTERN = Pattern.compile("(.+):([0-9]+): \\[(.*)\\] (.*)");
    private String pylint = "pylint";
    private String pylintConfigParam = null;

    PylintViolationsAnalyzer(String pylintPath, String pylintConfigPath) {
        if (pylintPath != null) {
            if (!new File(pylintPath).exists()) {
                throw new SonarException("Cannot find the pylint executable: " + pylintPath);
            }
            this.pylint = pylintPath;
        }
        if (pylintConfigPath != null) {
            if (!new File(pylintConfigPath).exists()) {
                throw new SonarException("Cannot find the pylint configuration file: " + pylintConfigPath);
            }
            this.pylintConfigParam = "--rcfile=" + pylintConfigPath;
        }
    }

    public List<Issue> analyze(String path, Charset charset, File out) throws IOException {
        Command command = Command.create((String)this.pylint).addArguments(ARGS).addArgument(path);
        if (this.pylintConfigParam != null) {
            command.addArgument(this.pylintConfigParam);
        }
        LOG.debug("Calling command: '{}'", (Object)command.toString());
        long timeoutMS = 300000L;
        MyStreamConsumer stdOut = new MyStreamConsumer();
        MyStreamConsumer stdErr = new MyStreamConsumer();
        CommandExecutor.create().execute(command, (StreamConsumer)stdOut, (StreamConsumer)stdErr, timeoutMS);
        if (stdErr.getData().size() > 1) {
            LOG.warn("Output on the error channel detected: this is probably due to a problem on pylint's side.");
            LOG.warn("Content of the error stream: \n\"{}\"", (Object)StringUtils.join(stdErr.getData(), (String)"\n"));
        }
        Files.write((CharSequence)StringUtils.join(stdOut.getData(), (String)"\n"), (File)out, (Charset)charset);
        return this.parseOutput(stdOut.getData());
    }

    protected List<Issue> parseOutput(List<String> lines) {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        String filename = null;
        String ruleid = null;
        String objname = null;
        String descr = null;
        if (!lines.isEmpty()) {
            for (String line : lines) {
                if (line.length() <= 0) continue;
                if (!this.isDetail(line)) {
                    Matcher m = PATTERN.matcher(line);
                    if (m.matches() && m.groupCount() == 4) {
                        filename = m.group(1);
                        int linenr = Integer.valueOf(m.group(2));
                        String[] parts = m.group(3).split(",");
                        ruleid = parts[0].trim();
                        if (ID_MAP.containsKey(ruleid)) {
                            ruleid = ID_MAP.get(ruleid);
                        }
                        if (parts.length == 2) {
                            objname = parts[1].trim();
                        }
                        descr = m.group(4);
                        issues.add(new Issue(filename, linenr, ruleid, objname, descr));
                        continue;
                    }
                    LOG.debug("Cannot parse the line: {}", (Object)line);
                    continue;
                }
                LOG.trace("Classifying as detail and ignoring line '{}'", (Object)line);
            }
        }
        return issues;
    }

    private boolean isDetail(String line) {
        char first = line.charAt(0);
        return first == ' ' || first == '\t' || first == '\n';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyStreamConsumer
    implements StreamConsumer {
        private List<String> data = new LinkedList<String>();

        private MyStreamConsumer() {
        }

        public void consumeLine(String line) {
            this.data.add(line);
        }

        public List<String> getData() {
            return this.data;
        }
    }
}

