/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;

public class Python
extends AbstractLanguage {
    public static final String KEY = "py";
    private static final String[] DEFAULT_FILE_SUFFIXES = new String[]{"py"};
    private Settings settings;

    public Python(Settings settings) {
        super(KEY, "Python");
        this.settings = settings;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = this.filterEmptyStrings(this.settings.getStringArray("sonar.python.file.suffixes"));
        return suffixes.length == 0 ? DEFAULT_FILE_SUFFIXES : suffixes;
    }

    private String[] filterEmptyStrings(String[] stringArray) {
        ArrayList nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }
}

