/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.coverage;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.coverage.CoberturaParser;
import org.sonar.plugins.python.coverage.FileResolver;

@Properties(value={@Property(key="sonar.python.coverage.reportPath", defaultValue="coverage-reports/coverage-*.xml", name="Path to coverage report(s)", description="Path to coverage reports, relative to project's root. Ant patterns are accepted. The reports have to conform to the Cobertura XML format.", global=false, project=true), @Property(key="sonar.python.coverage.itReportPath", defaultValue="coverage-reports/it-coverage-*.xml", name="Path to coverage report(s) for integration tests", description="Path to coverage reports for integration tests, relative to project's root. Ant patterns are accepted. The reports have to conform to the Cobertura XML format.", global=false, project=true)})
public class PythonCoverageSensor
extends PythonReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.python.coverage.reportPath";
    public static final String IT_REPORT_PATH_KEY = "sonar.python.coverage.itReportPath";
    public static final String DEFAULT_REPORT_PATH = "coverage-reports/coverage-*.xml";
    public static final String IT_DEFAULT_REPORT_PATH = "coverage-reports/it-coverage-*.xml";
    private CoberturaParser parser = new CoberturaParser();

    public PythonCoverageSensor(Settings conf, ModuleFileSystem fileSystem) {
        super(conf, fileSystem);
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        List<File> reports = this.getReports(this.conf, this.fileSystem.baseDir().getPath(), REPORT_PATH_KEY, DEFAULT_REPORT_PATH);
        LOG.debug("Parsing coverage reports");
        Map<String, CoverageMeasuresBuilder> coverageMeasures = this.parseReports(reports);
        this.saveMeasures(project, context, coverageMeasures, false);
        LOG.debug("Parsing integration test coverage reports");
        List<File> itReports = this.getReports(this.conf, this.fileSystem.baseDir().getPath(), IT_REPORT_PATH_KEY, IT_DEFAULT_REPORT_PATH);
        coverageMeasures = this.parseReports(itReports);
        this.saveMeasures(project, context, coverageMeasures, true);
    }

    private Map<String, CoverageMeasuresBuilder> parseReports(List<File> reports) {
        HashMap<String, CoverageMeasuresBuilder> coverageMeasures = new HashMap<String, CoverageMeasuresBuilder>();
        for (File report : reports) {
            try {
                this.parser.parseReport(report, coverageMeasures);
            }
            catch (XMLStreamException e) {
                throw new SonarException("Error parsing the report '" + report + "'", (Throwable)e);
            }
        }
        return coverageMeasures;
    }

    private void saveMeasures(Project project, SensorContext context, Map<String, CoverageMeasuresBuilder> coverageMeasures, boolean itTest) {
        FileResolver fileResolver = new FileResolver(project, this.fileSystem);
        for (Map.Entry<String, CoverageMeasuresBuilder> entry : coverageMeasures.entrySet()) {
            String filePath = entry.getKey();
            org.sonar.api.resources.File pythonfile = fileResolver.getFile(filePath);
            if (this.fileExist(context, pythonfile)) {
                LOG.debug("Saving coverage measures for file '{}'", (Object)filePath);
                for (Measure measure : entry.getValue().createMeasures()) {
                    measure = itTest ? this.convertToItMeasure(measure) : measure;
                    context.saveMeasure((Resource)pythonfile, measure);
                }
                continue;
            }
            LOG.debug("Cannot find the file '{}', ignoring coverage measures", (Object)filePath);
        }
    }

    Measure convertToItMeasure(Measure measure) {
        Measure itMeasure = null;
        Metric metric = measure.getMetric();
        Double value = measure.getValue();
        if (CoreMetrics.LINES_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, value);
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, measure.getData());
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, value);
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, measure.getData());
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, measure.getData());
        }
        return itMeasure;
    }

    private boolean fileExist(SensorContext context, org.sonar.api.resources.File file) {
        return context.getResource((Resource)file) != null;
    }
}

