/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintConfiguration;
import org.sonar.plugins.python.pylint.PylintIssuesAnalyzer;

public class PylintSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PylintSensor.class);
    private RuleFinder ruleFinder;
    private RulesProfile profile;
    private PylintConfiguration conf;
    private ModuleFileSystem fileSystem;
    private ResourcePerspectives resourcePerspectives;

    public PylintSensor(RuleFinder ruleFinder, PylintConfiguration conf, RulesProfile profile, ModuleFileSystem fileSystem, ResourcePerspectives resourcePerspectives) {
        this.ruleFinder = ruleFinder;
        this.conf = conf;
        this.profile = profile;
        this.fileSystem = fileSystem;
        this.resourcePerspectives = resourcePerspectives;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"py"})).isEmpty() && !this.profile.getActiveRulesByRepository("Pylint").isEmpty();
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File workdir = new File(this.fileSystem.workingDir(), "/pylint/");
        PylintSensor.prepareWorkDir(workdir);
        int i = 0;
        for (File file : this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"py"}))) {
            try {
                File out = new File(workdir, i + ".out");
                this.analyzeFile(file, out, project, sensorContext);
                ++i;
            }
            catch (Exception e) {
                String msg = "Cannot analyse the file '" + file.getAbsolutePath() + "', details: '" + e + "'";
                throw new SonarException(msg, (Throwable)e);
            }
        }
    }

    protected void analyzeFile(File file, File out, Project project, SensorContext sensorContext) throws IOException {
        org.sonar.api.resources.File pyfile = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
        String pylintConfigPath = this.conf.getPylintConfigPath(this.fileSystem);
        String pylintPath = this.conf.getPylintPath();
        PylintIssuesAnalyzer analyzer = new PylintIssuesAnalyzer(pylintPath, pylintConfigPath);
        List<Issue> issues = analyzer.analyze(file.getAbsolutePath(), this.fileSystem.sourceCharset(), out);
        for (Issue pylintIssue : issues) {
            Rule rule = this.ruleFinder.findByKey("Pylint", pylintIssue.getRuleId());
            if (rule != null) {
                if (rule.isEnabled().booleanValue()) {
                    Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)pyfile);
                    if (issuable == null) continue;
                    org.sonar.api.issue.Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)rule.getRepositoryKey(), (String)rule.getKey())).line(Integer.valueOf(pylintIssue.getLine())).message(pylintIssue.getDescr()).build();
                    issuable.addIssue(issue);
                    continue;
                }
                LOG.debug("Pylint rule '{}' is disabled in Sonar", (Object)pylintIssue.getRuleId());
                continue;
            }
            LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)pylintIssue.getRuleId());
        }
    }

    private static void prepareWorkDir(File dir) {
        try {
            FileUtils.forceMkdir((File)dir);
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new SonarException("Cannot create directory: " + dir, (Throwable)e);
        }
    }
}

