/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.python.Python;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.xunit.TestSuite;
import org.sonar.plugins.python.xunit.TestSuiteParser;

@Properties(value={@Property(key="sonar.python.xunit.reportPath", defaultValue="xunit-reports/xunit-result-*.xml", name="Path to xunit report(s)", description="Path to the report of test execution, relative to project's root. Ant patterns are accepted. The reports have to conform to the junitreport XML format.", global=false, project=true)})
public class PythonXunitSensor
extends PythonReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.python.xunit.reportPath";
    public static final String DEFAULT_REPORT_PATH = "xunit-reports/xunit-result-*.xml";
    private Python lang = null;

    public PythonXunitSensor(Settings conf, Python lang, ModuleFileSystem fileSystem) {
        super(conf, fileSystem);
        this.lang = lang;
    }

    @DependsUpon
    public Class dependsUponCoverageSensors() {
        return CoverageExtension.class;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReport(Project project, SensorContext context, File report) throws XMLStreamException {
        this.parseReport(project, context, report);
    }

    private void parseReport(Project project, SensorContext context, File report) throws XMLStreamException {
        LOG.info("Parsing report '{}'", (Object)report);
        TestSuiteParser parserHandler = new TestSuiteParser();
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)parserHandler, false);
        parser.parse(report);
        Collection<TestSuite> locatedResources = this.lookupResources(project, context, parserHandler.getParsedReports());
        for (TestSuite fileReport : locatedResources) {
            org.sonar.api.resources.File unitTest = fileReport.getSonarResource();
            LOG.debug("Saving test execution measures for file '{}' under resource '{}'", (Object)fileReport.getKey(), (Object)unitTest);
            double testsCount = fileReport.getTests() - fileReport.getSkipped();
            context.saveMeasure((Resource)unitTest, CoreMetrics.SKIPPED_TESTS, Double.valueOf(fileReport.getSkipped()));
            context.saveMeasure((Resource)unitTest, CoreMetrics.TESTS, Double.valueOf(testsCount));
            context.saveMeasure((Resource)unitTest, CoreMetrics.TEST_ERRORS, Double.valueOf(fileReport.getErrors()));
            context.saveMeasure((Resource)unitTest, CoreMetrics.TEST_FAILURES, Double.valueOf(fileReport.getFailures()));
            context.saveMeasure((Resource)unitTest, CoreMetrics.TEST_EXECUTION_TIME, Double.valueOf(fileReport.getTime()));
            double passedTests = testsCount - (double)fileReport.getErrors() - (double)fileReport.getFailures();
            if (testsCount > 0.0) {
                double percentage = passedTests * 100.0 / testsCount;
                context.saveMeasure((Resource)unitTest, CoreMetrics.TEST_SUCCESS_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)percentage)));
            }
            context.saveMeasure((Resource)unitTest, new Measure(CoreMetrics.TEST_DATA, fileReport.getDetails()));
        }
    }

    org.sonar.api.resources.File findResource(Project project, SensorContext context, String fileKey) {
        return this.findResourceUsingNosetestsStrategy(project, context, fileKey);
    }

    org.sonar.api.resources.File findResourceUsingNosetestsStrategy(Project project, SensorContext context, String fileKey) {
        String actualKey = StringUtils.replace((String)fileKey, (String)".", (String)"/") + ".py";
        org.sonar.api.resources.File unitTestFile = this.getSonarTestFile(new File(actualKey), project);
        if (context.getResource((Resource)unitTestFile) == null && context.getResource((Resource)(unitTestFile = this.getSonarTestFile(new File(actualKey = StringUtils.replace((String)StringUtils.substringBeforeLast((String)fileKey, (String)"."), (String)".", (String)"/") + ".py"), project))) == null) {
            unitTestFile = null;
        }
        return unitTestFile;
    }

    private Collection<TestSuite> lookupResources(Project project, SensorContext context, Collection<TestSuite> testReports) {
        HashMap<String, TestSuite> locatedReports = new HashMap<String, TestSuite>();
        for (TestSuite report : testReports) {
            TestSuite summaryReport;
            String fileKey = report.getKey();
            org.sonar.api.resources.File resource = this.findResource(project, context, fileKey);
            if (resource == null) {
                LOG.debug("Cannot find the resource for {}, creating a virtual one", (Object)fileKey);
                resource = this.createVirtualFile(context, fileKey);
            }
            if ((summaryReport = (TestSuite)locatedReports.get(resource.getKey())) != null) {
                LOG.debug("Adding measures of {} to {}", (Object)summaryReport.getKey(), (Object)report.getKey());
                summaryReport.addMeasures(report);
                continue;
            }
            report.setSonarResource(resource);
            locatedReports.put(resource.getKey(), report);
        }
        return locatedReports.values();
    }

    private org.sonar.api.resources.File createVirtualFile(SensorContext context, String filename) {
        org.sonar.api.resources.File virtualFile = new org.sonar.api.resources.File((Language)this.lang, filename);
        virtualFile.setQualifier("UTS");
        context.saveSource((Resource)virtualFile, "<source code could not be found>");
        return virtualFile;
    }

    private org.sonar.api.resources.File getSonarTestFile(File file, Project project) {
        org.sonar.api.resources.File unitTestFile = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
        if (unitTestFile == null) {
            unitTestFile = org.sonar.api.resources.File.fromIOFile((File)file, (List)this.fileSystem.testDirs());
        }
        return unitTestFile;
    }
}

