/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.python.pylint.Issue;

public class PylintReportParser {
    private static final Pattern PATTERN = Pattern.compile("(.+):([0-9]+): \\[(.*)\\] (.*)");
    private static final Logger LOG = LoggerFactory.getLogger(PylintReportParser.class);
    private static final Map<String, String> ID_MAP = ImmutableMap.builder().put((Object)"E9900", (Object)"E1300").put((Object)"E9901", (Object)"E1301").put((Object)"E9902", (Object)"E1302").put((Object)"E9903", (Object)"E1303").put((Object)"E9904", (Object)"E1304").put((Object)"E9905", (Object)"E1305").put((Object)"E9906", (Object)"E1306").put((Object)"W6501", (Object)"W1201").put((Object)"W9900", (Object)"W1300").put((Object)"W9901", (Object)"W1301").build();

    public Issue parseLine(String line) {
        Issue issue = null;
        String ruleid = null;
        String objname = null;
        String descr = null;
        String filename = null;
        if (line.length() > 0) {
            if (!this.isDetail(line)) {
                Matcher m = PATTERN.matcher(line);
                if (m.matches() && m.groupCount() == 4) {
                    filename = m.group(1);
                    int linenr = Integer.valueOf(m.group(2));
                    String[] parts = m.group(3).split(",");
                    ruleid = this.ruleId(parts[0].trim());
                    objname = parts.length == 2 ? parts[1].trim() : "";
                    descr = m.group(4);
                    issue = new Issue(filename, linenr, ruleid, objname, descr);
                } else {
                    LOG.debug("Cannot parse the line: {}", (Object)line);
                }
            } else {
                LOG.trace("Classifying as detail and ignoring line '{}'", (Object)line);
            }
        }
        return issue;
    }

    private String ruleId(String ruleAndMessageIds) {
        String ruleid = ruleAndMessageIds;
        int parenthesisIndex = ruleid.indexOf(40);
        if (parenthesisIndex > -1) {
            ruleid = ruleid.substring(0, parenthesisIndex);
        }
        if (ID_MAP.containsKey(ruleid)) {
            ruleid = ID_MAP.get(ruleid);
        }
        return ruleid;
    }

    private boolean isDetail(String line) {
        char first = line.charAt(0);
        return first == ' ' || first == '\t' || first == '\n';
    }
}

