/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintConfiguration;
import org.sonar.plugins.python.pylint.PylintIssuesAnalyzer;

public class PylintSensor
implements Sensor {
    public static final String REPORT_PATH_KEY = "sonar.python.pylint.reportPath";
    private static final Logger LOG = LoggerFactory.getLogger(PylintSensor.class);
    private ActiveRules activeRules;
    private PylintConfiguration conf;
    private FileSystem fileSystem;
    private ResourcePerspectives resourcePerspectives;
    private Settings settings;

    public PylintSensor(PylintConfiguration conf, ActiveRules activeRules, FileSystem fileSystem, ResourcePerspectives resourcePerspectives, Settings settings) {
        this.conf = conf;
        this.activeRules = activeRules;
        this.fileSystem = fileSystem;
        this.resourcePerspectives = resourcePerspectives;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        FilePredicates p = this.fileSystem.predicates();
        boolean hasFiles = this.fileSystem.hasFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        boolean hasRules = !this.activeRules.findByRepository("Pylint").isEmpty();
        return hasFiles && hasRules && this.settings.getString(REPORT_PATH_KEY) == null;
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File workDir = new File(this.fileSystem.workDir(), "/pylint/");
        PylintSensor.prepareWorkDir(workDir);
        int i = 0;
        FilePredicates p = this.fileSystem.predicates();
        Iterable files = this.fileSystem.files(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        for (File file : files) {
            try {
                File out = new File(workDir, i + ".out");
                this.analyzeFile(file, out);
                ++i;
            }
            catch (Exception e) {
                String msg = "Cannot analyse the file '" + file.getAbsolutePath() + "', details: '" + e + "'";
                throw new IllegalStateException(msg, e);
            }
        }
    }

    protected void analyzeFile(File file, File out) throws IOException {
        InputFile pyFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(file));
        String pylintConfigPath = this.conf.getPylintConfigPath(this.fileSystem);
        String pylintPath = this.conf.getPylintPath();
        PylintIssuesAnalyzer analyzer = new PylintIssuesAnalyzer(pylintPath, pylintConfigPath);
        List<Issue> issues = analyzer.analyze(file.getAbsolutePath(), this.fileSystem.encoding(), out);
        for (Issue pylintIssue : issues) {
            ActiveRule rule = this.activeRules.find(RuleKey.of((String)"Pylint", (String)pylintIssue.getRuleId()));
            if (rule != null) {
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (InputPath)pyFile);
                if (issuable == null) continue;
                org.sonar.api.issue.Issue issue = issuable.newIssueBuilder().ruleKey(rule.ruleKey()).line(Integer.valueOf(pylintIssue.getLine())).message(pylintIssue.getDescription()).build();
                issuable.addIssue(issue);
                continue;
            }
            LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)pylintIssue.getRuleId());
        }
    }

    private static void prepareWorkDir(File dir) {
        try {
            FileUtils.forceMkdir((File)dir);
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create directory: " + dir, e);
        }
    }
}

