/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.python.xunit.TestCase;
import org.sonar.plugins.python.xunit.TestSuite;

public class TestSuiteParser
implements StaxParser.XmlStreamHandler {
    private Map<String, TestSuite> testSuites = new HashMap<String, TestSuite>();

    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuiteCursor = rootCursor.constructDescendantCursor((SMFilter)new ElementFilter("testsuite"));
        while (testSuiteCursor.getNext() != null) {
            String testSuiteClassName = testSuiteCursor.getAttrValue("name");
            SMInputCursor testCaseCursor = testSuiteCursor.childElementCursor("testcase");
            while (testCaseCursor.getNext() != null) {
                String testClassName = this.getClassname(testCaseCursor, testSuiteClassName);
                TestSuite report = this.testSuites.get(testClassName);
                if (report == null) {
                    report = new TestSuite(testClassName);
                    this.testSuites.put(testClassName, report);
                }
                report.addTestCase(this.parseTestCaseTag(testCaseCursor));
            }
        }
    }

    public Collection<TestSuite> getParsedReports() {
        return this.testSuites.values();
    }

    private String getClassname(SMInputCursor testCaseCursor, String defaultClassname) throws XMLStreamException {
        String testClassName = testCaseCursor.getAttrValue("classname");
        return testClassName == null ? defaultClassname : testClassName;
    }

    private TestCase parseTestCaseTag(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = this.parseTestCaseName(testCaseCursor);
        Double time = this.parseTime(testCaseCursor);
        String status = "ok";
        String stack = "";
        String msg = "";
        SMInputCursor childCursor = testCaseCursor.childElementCursor();
        if (childCursor.getNext() != null) {
            String elementName = childCursor.getLocalName();
            if ("skipped".equals(elementName)) {
                status = "skipped";
            } else if ("failure".equals(elementName)) {
                status = "failure";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            } else if ("error".equals(elementName)) {
                status = "error";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            }
        }
        return new TestCase(name, time.intValue(), status, stack, msg);
    }

    private double parseTime(SMInputCursor testCaseCursor) throws XMLStreamException {
        double time = 0.0;
        try {
            Double tmp = ParsingUtils.parseNumber((String)testCaseCursor.getAttrValue("time"), (Locale)Locale.ENGLISH);
            time = ParsingUtils.scaleValue((double)(tmp * 1000.0), (int)3);
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
        return time;
    }

    private String parseTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = testCaseCursor.getAttrValue("name");
        String classname = testCaseCursor.getAttrValue("CLASSNAME");
        if (classname != null) {
            name = classname + "/" + name;
        }
        return name;
    }
}

