/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.coverage;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.plugins.python.EmptyReportException;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.coverage.CoberturaParser;

@Properties(value={@Property(key="sonar.python.coverage.reportPath", defaultValue="coverage-reports/coverage-*.xml", name="Path to coverage report(s)", description="Path to coverage reports, relative to project's root. Ant patterns are accepted. The reports have to conform to the Cobertura XML format.", global=false, project=true), @Property(key="sonar.python.coverage.itReportPath", defaultValue="coverage-reports/it-coverage-*.xml", name="Path to coverage report(s) for integration tests", description="Path to coverage reports for integration tests, relative to project's root. Ant patterns are accepted. The reports have to conform to the Cobertura XML format.", global=false, project=true), @Property(key="sonar.python.coverage.overallReportPath", defaultValue="coverage-reports/overall-coverage-*.xml", name="Path to overall (combined UT+IT) coverage report(s)", description="Path to a report containing overall test coverage data (i.e. test coverage gained by all tests of all kinds), relative to projects root. Ant patterns are accepted. The reports have to conform to the Cobertura XML format.", global=false, project=true), @Property(key="sonar.python.coverage.forceZeroCoverage", type=PropertyType.BOOLEAN, defaultValue="false", name="Assign zero line coverage to source files without coverage report(s)", description="If 'True', assign zero line coverage to source files without coverage report(s), which results in a more realistic overall Technical Debt value.", global=false, project=true)})
public class PythonCoverageSensor
extends PythonReportSensor {
    private static final Logger LOG = LoggerFactory.getLogger(PythonCoverageSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.python.coverage.reportPath";
    public static final String IT_REPORT_PATH_KEY = "sonar.python.coverage.itReportPath";
    public static final String OVERALL_REPORT_PATH_KEY = "sonar.python.coverage.overallReportPath";
    public static final String DEFAULT_REPORT_PATH = "coverage-reports/coverage-*.xml";
    public static final String IT_DEFAULT_REPORT_PATH = "coverage-reports/it-coverage-*.xml";
    public static final String OVERALL_DEFAULT_REPORT_PATH = "coverage-reports/overall-coverage-*.xml";
    public static final String FORCE_ZERO_COVERAGE_KEY = "sonar.python.coverage.forceZeroCoverage";
    private CoberturaParser parser = new CoberturaParser();

    public PythonCoverageSensor(Settings conf, FileSystem fileSystem) {
        super(conf, fileSystem);
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        String baseDir = this.fileSystem.baseDir().getPath();
        List<File> reports = this.getReports(this.conf, baseDir, REPORT_PATH_KEY, DEFAULT_REPORT_PATH);
        LOG.debug("Parsing coverage reports");
        Map<String, CoverageMeasuresBuilder> coverageMeasures = this.parseReports(reports);
        this.saveMeasures(context, coverageMeasures, CoverageType.UT_COVERAGE);
        LOG.debug("Parsing integration test coverage reports");
        List<File> itReports = this.getReports(this.conf, baseDir, IT_REPORT_PATH_KEY, IT_DEFAULT_REPORT_PATH);
        Map<String, CoverageMeasuresBuilder> itCoverageMeasures = this.parseReports(itReports);
        this.saveMeasures(context, itCoverageMeasures, CoverageType.IT_COVERAGE);
        LOG.debug("Parsing overall test coverage reports");
        List<File> overallReports = this.getReports(this.conf, baseDir, OVERALL_REPORT_PATH_KEY, OVERALL_DEFAULT_REPORT_PATH);
        Map<String, CoverageMeasuresBuilder> overallCoverageMeasures = this.parseReports(overallReports);
        this.saveMeasures(context, overallCoverageMeasures, CoverageType.OVERALL_COVERAGE);
        if (this.conf.getBoolean(FORCE_ZERO_COVERAGE_KEY)) {
            LOG.debug("Zeroing coverage information for untouched files");
            this.zeroMeasuresWithoutReports(context, coverageMeasures, itCoverageMeasures, overallCoverageMeasures);
        }
    }

    private void zeroMeasuresWithoutReports(SensorContext context, Map<String, CoverageMeasuresBuilder> coverageMeasures, Map<String, CoverageMeasuresBuilder> itCoverageMeasures, Map<String, CoverageMeasuresBuilder> overallCoverageMeasures) {
        FilePredicates p = this.fileSystem.predicates();
        Iterable inputFiles = this.fileSystem.inputFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        for (InputFile inputFile : inputFiles) {
            String filePath = inputFile.relativePath();
            if (coverageMeasures.get(filePath) == null) {
                this.saveZeroValueForResource(inputFile, filePath, context, CoverageType.UT_COVERAGE);
            }
            if (itCoverageMeasures.get(filePath) == null) {
                this.saveZeroValueForResource(inputFile, filePath, context, CoverageType.IT_COVERAGE);
            }
            if (overallCoverageMeasures.get(filePath) != null) continue;
            this.saveZeroValueForResource(inputFile, filePath, context, CoverageType.OVERALL_COVERAGE);
        }
    }

    private void saveZeroValueForResource(InputFile inputFile, String filePath, SensorContext context, CoverageType ctype) {
        Measure ncloc = context.getMeasure(context.getResource((InputPath)inputFile), CoreMetrics.NCLOC);
        if (ncloc != null && ncloc.getValue() > 0.0) {
            String coverageKind = "unit test";
            Metric hitsDataMetric = CoreMetrics.COVERAGE_LINE_HITS_DATA;
            Metric linesToCoverMetric = CoreMetrics.LINES_TO_COVER;
            Metric uncoveredLinesMetric = CoreMetrics.UNCOVERED_LINES;
            switch (ctype) {
                case IT_COVERAGE: {
                    coverageKind = "integration test";
                    hitsDataMetric = CoreMetrics.IT_COVERAGE_LINE_HITS_DATA;
                    linesToCoverMetric = CoreMetrics.IT_LINES_TO_COVER;
                    uncoveredLinesMetric = CoreMetrics.IT_UNCOVERED_LINES;
                    break;
                }
                case OVERALL_COVERAGE: {
                    coverageKind = "overall";
                    hitsDataMetric = CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA;
                    linesToCoverMetric = CoreMetrics.OVERALL_LINES_TO_COVER;
                    uncoveredLinesMetric = CoreMetrics.OVERALL_UNCOVERED_LINES;
                    break;
                }
            }
            LOG.debug("Zeroing {} coverage measures for file '{}'", (Object)coverageKind, (Object)filePath);
            PropertiesBuilder lineHitsData = new PropertiesBuilder(hitsDataMetric);
            for (int i = 1; i <= inputFile.lines(); ++i) {
                lineHitsData.add((Object)i, (Object)0);
            }
            context.saveMeasure(inputFile, lineHitsData.build());
            context.saveMeasure(inputFile, linesToCoverMetric, ncloc.getValue());
            context.saveMeasure(inputFile, uncoveredLinesMetric, ncloc.getValue());
        }
    }

    private Map<String, CoverageMeasuresBuilder> parseReports(List<File> reports) {
        HashMap<String, CoverageMeasuresBuilder> coverageMeasures = new HashMap<String, CoverageMeasuresBuilder>();
        for (File report : reports) {
            try {
                this.parser.parseReport(report, coverageMeasures);
            }
            catch (EmptyReportException e) {
                LOG.warn("The report '{}' seems to be empty, ignoring. '{}'", (Object)report, (Object)e);
            }
            catch (XMLStreamException e) {
                throw new IllegalStateException("Error parsing the report '" + report + "'", e);
            }
        }
        return coverageMeasures;
    }

    private void saveMeasures(SensorContext context, Map<String, CoverageMeasuresBuilder> coverageMeasures, CoverageType coverageType) {
        for (Map.Entry<String, CoverageMeasuresBuilder> entry : coverageMeasures.entrySet()) {
            String filePath = entry.getKey();
            InputFile pythonFile = this.fileSystem.inputFile(this.fileSystem.predicates().hasPath(filePath));
            if (pythonFile != null) {
                LOG.debug("Saving coverage measures for file '{}'", (Object)filePath);
                for (Measure measure : entry.getValue().createMeasures()) {
                    switch (coverageType) {
                        case IT_COVERAGE: {
                            measure = this.convertToITMeasure(measure);
                            break;
                        }
                        case OVERALL_COVERAGE: {
                            measure = this.convertForOverall(measure);
                            break;
                        }
                    }
                    context.saveMeasure(pythonFile, measure);
                }
                continue;
            }
            LOG.debug("Cannot find the file '{}', ignoring coverage measures", (Object)filePath);
        }
    }

    Measure convertToITMeasure(Measure measure) {
        Measure itMeasure = null;
        Metric metric = measure.getMetric();
        Double value = measure.getValue();
        String data = measure.getData();
        if (CoreMetrics.LINES_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_LINES_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_LINES, value);
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)metric)) {
            this.checkDataIsNotNull(data);
            itMeasure = new Measure(CoreMetrics.IT_COVERAGE_LINE_HITS_DATA, data);
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_TO_COVER, value);
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)metric)) {
            itMeasure = new Measure(CoreMetrics.IT_UNCOVERED_CONDITIONS, value);
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)metric)) {
            this.checkDataIsNotNull(data);
            itMeasure = new Measure(CoreMetrics.IT_COVERED_CONDITIONS_BY_LINE, data);
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)metric)) {
            this.checkDataIsNotNull(data);
            itMeasure = new Measure(CoreMetrics.IT_CONDITIONS_BY_LINE, data);
        }
        return itMeasure;
    }

    private Measure convertForOverall(Measure measure) {
        Measure overallMeasure = null;
        String data = measure.getData();
        if (CoreMetrics.LINES_TO_COVER.equals((Object)measure.getMetric())) {
            overallMeasure = new Measure(CoreMetrics.OVERALL_LINES_TO_COVER, measure.getValue());
        } else if (CoreMetrics.UNCOVERED_LINES.equals((Object)measure.getMetric())) {
            overallMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_LINES, measure.getValue());
        } else if (CoreMetrics.COVERAGE_LINE_HITS_DATA.equals((Object)measure.getMetric())) {
            this.checkDataIsNotNull(data);
            overallMeasure = new Measure(CoreMetrics.OVERALL_COVERAGE_LINE_HITS_DATA, data);
        } else if (CoreMetrics.CONDITIONS_TO_COVER.equals((Object)measure.getMetric())) {
            overallMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_TO_COVER, measure.getValue());
        } else if (CoreMetrics.UNCOVERED_CONDITIONS.equals((Object)measure.getMetric())) {
            overallMeasure = new Measure(CoreMetrics.OVERALL_UNCOVERED_CONDITIONS, measure.getValue());
        } else if (CoreMetrics.COVERED_CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
            this.checkDataIsNotNull(data);
            overallMeasure = new Measure(CoreMetrics.OVERALL_COVERED_CONDITIONS_BY_LINE, data);
        } else if (CoreMetrics.CONDITIONS_BY_LINE.equals((Object)measure.getMetric())) {
            this.checkDataIsNotNull(data);
            overallMeasure = new Measure(CoreMetrics.OVERALL_CONDITIONS_BY_LINE, data);
        }
        return overallMeasure;
    }

    private void checkDataIsNotNull(@Nullable String data) {
        if (data == null) {
            throw new IllegalStateException("Measure data is null but it shouldn't be");
        }
    }

    private static enum CoverageType {
        UT_COVERAGE,
        IT_COVERAGE,
        OVERALL_COVERAGE;

    }
}

