/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.xpath.api.AstNodeXPathQuery;
import java.awt.Point;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.sonar.sslr.internal.toolkit.SourceCodeModel;
import org.sonar.sslr.internal.toolkit.ToolkitView;

public class ToolkitPresenter {
    public final SourceCodeModel model;
    public ToolkitView view = null;

    public ToolkitPresenter(SourceCodeModel model) {
        this.model = model;
    }

    public void setView(ToolkitView view) {
        Preconditions.checkNotNull(view);
        this.view = view;
    }

    @VisibleForTesting
    void checkInitialized() {
        Preconditions.checkState(this.view != null, "the view must be set before the presenter can be ran");
    }

    @VisibleForTesting
    void initUncaughtExceptionsHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                ToolkitPresenter.this.view.appendToConsole(((Object)result).toString());
                ToolkitPresenter.this.view.setFocusOnConsoleView();
            }
        });
    }

    public void run(String title) {
        this.checkInitialized();
        this.initUncaughtExceptionsHandler();
        this.view.setTitle(title);
        this.view.displayHighlightedSourceCode("");
        this.view.displayAst(null);
        this.view.displayXml("");
        this.view.disableXPathEvaluateButton();
        this.view.run();
    }

    public void onSourceCodeOpenButtonClick() {
        File fileToParse = this.view.pickFileToParse();
        if (fileToParse != null) {
            this.view.clearConsole();
            this.model.setSourceCode(fileToParse, Charset.defaultCharset());
            this.view.displayHighlightedSourceCode(this.model.getHighlightedSourceCode());
            this.view.displayAst(this.model.getAstNode());
            this.view.displayXml(this.model.getXml());
            this.view.scrollSourceCodeTo(new Point(0, 0));
            this.view.setFocusOnAbstractSyntaxTreeView();
            this.view.enableXPathEvaluateButton();
        }
    }

    public void onSourceCodeParseButtonClick() {
        this.view.clearConsole();
        String sourceCode = this.view.getSourceCode();
        this.model.setSourceCode(sourceCode);
        Point sourceCodeScrollbarPosition = this.view.getSourceCodeScrollbarPosition();
        this.view.displayHighlightedSourceCode(this.model.getHighlightedSourceCode());
        this.view.displayAst(this.model.getAstNode());
        this.view.displayXml(this.model.getXml());
        this.view.scrollSourceCodeTo(sourceCodeScrollbarPosition);
        this.view.setFocusOnAbstractSyntaxTreeView();
        this.view.enableXPathEvaluateButton();
    }

    public void onXPathEvaluateButtonClick() {
        String xpath = this.view.getXPath();
        AstNodeXPathQuery xpathQuery = AstNodeXPathQuery.create(xpath);
        this.view.clearConsole();
        this.view.clearAstSelections();
        this.view.clearSourceCodeHighlights();
        AstNode firstAstNode = null;
        for (Object resultObject : xpathQuery.selectNodes(this.model.getAstNode())) {
            if (!(resultObject instanceof AstNode)) continue;
            AstNode resultAstNode = (AstNode)resultObject;
            if (firstAstNode == null) {
                firstAstNode = resultAstNode;
            }
            this.view.selectAstNode(resultAstNode);
            this.view.highlightSourceCode(resultAstNode);
        }
        this.view.scrollAstTo(firstAstNode);
        this.view.scrollSourceCodeTo(firstAstNode);
        this.view.setFocusOnAbstractSyntaxTreeView();
    }

    public void onSourceCodeKeyTyped() {
        this.view.displayAst(null);
        this.view.displayXml("");
        this.view.clearSourceCodeHighlights();
        this.view.disableXPathEvaluateButton();
    }

    public void onSourceCodeTextCursorMoved() {
        this.view.clearAstSelections();
        AstNode astNode = this.view.getAstNodeFollowingCurrentSourceCodeTextCursorPosition();
        this.view.selectAstNode(astNode);
        this.view.scrollAstTo(astNode);
    }

    public void onAstSelectionChanged() {
        this.view.clearSourceCodeHighlights();
        AstNode firstAstNode = null;
        for (AstNode astNode : this.view.getSelectedAstNodes()) {
            if (firstAstNode == null) {
                firstAstNode = astNode;
            }
            this.view.highlightSourceCode(astNode);
        }
        this.view.scrollSourceCodeTo(firstAstNode);
    }
}

