/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Preprocessor;
import com.sonar.sslr.api.PreprocessorAction;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.LexerState;

public class IndentationPreprocessor
extends Preprocessor {
    private final LexerState lexerState;

    public IndentationPreprocessor(LexerState lexerState) {
        this.lexerState = lexerState;
    }

    @Override
    public void init() {
        this.lexerState.reset();
    }

    @Override
    public PreprocessorAction process(List<Token> tokens) {
        Token token = tokens.get(0);
        if (token.getType() == GenericTokenType.EOF) {
            if (this.lexerState.indentationStack.isEmpty()) {
                return PreprocessorAction.NO_OPERATION;
            }
            ArrayList<Token> tokensToInject = Lists.newArrayList();
            while (this.lexerState.indentationStack.peek() > 0) {
                this.lexerState.indentationStack.pop();
                tokensToInject.add(Token.builder(token).setURI(token.getURI()).setType(PythonTokenType.DEDENT).setLine(token.getLine()).setColumn(token.getColumn()).setValueAndOriginalValue("").build());
            }
            return new PreprocessorAction(0, Collections.EMPTY_LIST, tokensToInject);
        }
        return PreprocessorAction.NO_OPERATION;
    }
}

