/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.metrics;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.Collection;
import java.util.Set;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;

public final class ComplexityVisitor<G extends Grammar>
extends SquidAstVisitor<G> {
    private final MetricDef metric;
    private final Set<AstNodeType> astNodeTypes;
    private final Set<AstNodeType> exclusionAstNodeTypes;

    private ComplexityVisitor(Builder<G> builder) {
        this.metric = ((Builder)builder).metric;
        this.astNodeTypes = ImmutableSet.copyOf(((Builder)builder).astNodeTypes);
        this.exclusionAstNodeTypes = ImmutableSet.copyOf(((Builder)builder).exclusionAstNodeTypes);
    }

    public static <G extends Grammar> Builder<G> builder() {
        return new Builder();
    }

    @Override
    public void init() {
        for (AstNodeType astNodeType : this.astNodeTypes) {
            this.subscribeTo(astNodeType);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        for (AstNodeType exclusionAstNodeType : this.exclusionAstNodeTypes) {
            if (!astNode.hasAncestor(exclusionAstNodeType)) continue;
            return;
        }
        this.getContext().peekSourceCode().add(this.metric, 1.0);
    }

    public static final class Builder<G extends Grammar> {
        private MetricDef metric;
        private Set<AstNodeType> astNodeTypes = Sets.newHashSet();
        private Set<AstNodeType> exclusionAstNodeTypes = Sets.newHashSet();

        private Builder() {
        }

        public Builder<G> setMetricDef(MetricDef metric) {
            this.metric = metric;
            return this;
        }

        public Builder<G> subscribeTo(AstNodeType ... astNodeTypes) {
            for (AstNodeType astNodeType : astNodeTypes) {
                this.astNodeTypes.add(astNodeType);
            }
            return this;
        }

        public Builder<G> subscribeTo(Collection<AstNodeType> astNodeTypes) {
            this.astNodeTypes = Sets.newHashSet(astNodeTypes);
            return this;
        }

        public Builder<G> setExclusions(Collection<AstNodeType> exclusionAstNodeTypes) {
            this.exclusionAstNodeTypes = Sets.newHashSet(exclusionAstNodeTypes);
            return this;
        }

        public Builder<G> addExclusions(AstNodeType ... exclusionAstNodeTypes) {
            for (AstNodeType exclusionAstNodeType : exclusionAstNodeTypes) {
                this.exclusionAstNodeTypes.add(exclusionAstNodeType);
            }
            return this;
        }

        public ComplexityVisitor<G> build() {
            return new ComplexityVisitor(this);
        }
    }
}

