/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.api;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceCodeIndexer;
import org.sonar.squidbridge.measures.Measurable;
import org.sonar.squidbridge.measures.Measures;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;

public abstract class SourceCode
implements Measurable,
Comparable<SourceCode> {
    private final String name;
    private final Measures measures = new Measures();
    private final String key;
    private int startAtLine = -1;
    private int endAtLine = -1;
    private SourceCode parent;
    private SortedSet<SourceCode> children;
    private SourceCodeIndexer indexer;
    private Set<CheckMessage> messages;

    public SourceCode(String key) {
        this(key, null);
    }

    public SourceCode(String key, @Nullable String name) {
        this.key = key;
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public int compareTo(SourceCode resource) {
        return this.key.compareTo(resource.getKey());
    }

    public String getName() {
        return this.name;
    }

    public final void setSourceCodeIndexer(SourceCodeIndexer indexer) {
        this.indexer = indexer;
    }

    private void index(SourceCode sourceCode) {
        if (this.indexer != null) {
            this.indexer.index(sourceCode);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SourceCode && this.key.equals(((SourceCode)obj).key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.getKey();
    }

    public boolean isType(Class<? extends SourceCode> resourceType) {
        return this.getClass() == resourceType;
    }

    public int getInt(MetricDef metric) {
        return (int)this.getMeasure(metric);
    }

    @Deprecated
    public int getInt(Metric metric) {
        return (int)this.getMeasure(metric);
    }

    public double getDouble(MetricDef metric) {
        return this.getMeasure(metric);
    }

    @Deprecated
    public double getDouble(Metric metric) {
        return this.getMeasure(metric);
    }

    public void add(MetricDef metric, SourceCode child) {
        this.add(metric, child.getMeasure(metric));
    }

    public void add(MetricDef metric, double value) {
        this.setMeasure(metric, this.getMeasure(metric) + value);
    }

    public void addData(MetricDef metric, Object data) {
        this.measures.setData(metric, data);
    }

    public Object getData(MetricDef metric) {
        return this.measures.getData(metric);
    }

    @Deprecated
    public Object getData(Metric metric) {
        return this.measures.getData(metric);
    }

    private double getMeasure(MetricDef metric) {
        if (metric.isCalculatedMetric()) {
            return metric.getCalculatedMetricFormula().calculate(this);
        }
        return this.measures.getValue(metric);
    }

    public void setMeasure(MetricDef metric, double measure) {
        if (metric.isCalculatedMetric()) {
            throw new IllegalStateException("It's not allowed to set the value of a calculated metric : " + metric.getName());
        }
        this.measures.setValue(metric, measure);
    }

    public void setMeasure(MetricDef metric, int measure) {
        this.setMeasure(metric, (double)measure);
    }

    public void removeMeasure(MetricDef metric) {
        this.measures.removeMeasure(metric);
    }

    public void setStartAtLine(int startAtLine) {
        this.startAtLine = startAtLine;
        this.endAtLine = startAtLine;
    }

    public void setEndAtLine(int endAtLine) {
        this.endAtLine = endAtLine;
    }

    public int getStartAtLine() {
        return this.startAtLine;
    }

    public int getEndAtLine() {
        return this.endAtLine;
    }

    public SourceCode addChild(SourceCode sourceCode) {
        if (this.children == null) {
            this.children = new TreeSet<SourceCode>();
        }
        sourceCode.setParent(this);
        if (!this.children.contains(sourceCode)) {
            this.children.add(sourceCode);
            this.index(sourceCode);
        }
        return this;
    }

    public <S extends SourceCode> S getParent(Class<S> sourceCode) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getClass().equals(sourceCode)) {
            return (S)this.parent;
        }
        return this.parent.getParent(sourceCode);
    }

    public <S extends SourceCode> S getAncestor(Class<S> withClass) {
        S parentAncestor;
        S ancestor = this.getParent(withClass);
        if (ancestor != null && (parentAncestor = ((SourceCode)ancestor).getAncestor(withClass)) != null) {
            ancestor = parentAncestor;
        }
        return ancestor;
    }

    public void log(CheckMessage message) {
        message.setSourceCode(this);
        this.getCheckMessages().add(message);
    }

    public Set<CheckMessage> getCheckMessages() {
        if (this.messages == null) {
            this.messages = new HashSet<CheckMessage>();
        }
        return this.messages;
    }

    public boolean hasCheckMessages() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public SourceCode getFirstChild() {
        return !this.children.isEmpty() ? this.children.first() : null;
    }

    public SourceCode getLastChild() {
        return !this.children.isEmpty() ? this.children.last() : null;
    }

    private void setParent(SourceCode parent) {
        this.parent = parent;
    }

    public SourceCode getParent() {
        return this.parent;
    }

    public Set<SourceCode> getChildren() {
        return this.children;
    }

    public boolean hasChild(SourceCode squidUnit) {
        if (!this.hasChildren()) {
            return false;
        }
        if (this.children.contains(squidUnit)) {
            return true;
        }
        for (SourceCode child : this.children) {
            if (!child.hasChild(squidUnit)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean hasAmongParents(SourceCode expectedParent) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.equals(expectedParent) || this.parent.hasAmongParents(expectedParent);
    }
}

