/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.lexer;

import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import com.sonar.sslr.impl.channel.UnknownCharacterChannel;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.lexer.IndentationChannel;
import org.sonar.python.lexer.IndentationPreprocessor;
import org.sonar.python.lexer.LexerState;
import org.sonar.python.lexer.NewLineChannel;
import org.sonar.python.lexer.StringLiteralsChannel;

public final class PythonLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BYTES_PREFIX = "(br|bR|b|Br|BR|B)";
    private static final String IMAGINARY_SUFFIX = "(j|J)";
    private static final String LONG_INTEGER_SUFFIX = "(l|L)";

    private PythonLexer() {
    }

    public static Lexer create(PythonConfiguration conf) {
        LexerState lexerState = new LexerState();
        return Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel(new NewLineChannel(lexerState)).withChannel(new IndentationChannel(lexerState)).withPreprocessor(new IndentationPreprocessor(lexerState)).withChannel(new BlackHoleChannel("\\s")).withChannel(RegexpChannelBuilder.commentRegexp("#[^\\n\\r]*+")).withChannel(new StringLiteralsChannel()).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.STRING, "(br|bR|b|Br|BR|B)'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.STRING, "(br|bR|b|Br|BR|B)\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++\\.[0-9]*+([Ee][+-]?+[0-9_]++)?+(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "\\.[0-9]++([Ee][+-]?+[0-9_]++)?+(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++([Ee][+-]?+[0-9_]++)(j|J)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[0-9]++(j|J)")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[oO]?+[0-7]++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[xX][0-9a-fA-F]++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0[bB][01]++(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "[1-9][0-9]*+(l|L)?+")).withChannel(RegexpChannelBuilder.regexp(PythonTokenType.NUMBER, "0++(l|L)?+")).withChannel(new IdentifierAndKeywordChannel(RegexpChannelBuilder.and("[a-zA-Z_]", RegexpChannelBuilder.o2n("\\w")), true, new TokenType[][]{PythonKeyword.values()})).withChannel(new PunctuatorChannel(PythonPunctuator.values())).withChannel(new UnknownCharacterChannel()).build();
    }
}

