/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.ProgressReport;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;

public class ProgressAstScanner<G extends Grammar>
extends AstScanner<G> {
    private final ProgressReport progressReport;

    protected ProgressAstScanner(Builder<G> builder) {
        super(builder);
        this.progressReport = ((Builder)builder).progressReport;
    }

    @Override
    public void scanFiles(Collection<File> files) {
        this.progressReport.start(files);
        super.scanFiles(files);
        this.progressReport.stop();
    }

    public static class Builder<G extends Grammar>
    extends AstScanner.Builder<G> {
        private ProgressReport progressReport = new ProgressReport("Report about progress of code analyzer", TimeUnit.SECONDS.toMillis(10L));

        public Builder(SquidAstVisitorContextImpl<G> context) {
            super(context);
        }

        public Builder<G> setProgressReport(ProgressReport progressReport) {
            this.progressReport = progressReport;
            return this;
        }

        @Override
        public AstScanner<G> build() {
            super.withSquidAstVisitor(new SquidAstVisitor<G>(){

                @Override
                public void leaveFile(@Nullable AstNode astNode) {
                    Builder.this.progressReport.nextFile();
                }
            });
            return new ProgressAstScanner(this);
        }
    }
}

