/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.squidbridge.CommentAnalyser;
import org.sonar.squidbridge.SquidAstVisitorContext;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.measures.MetricDef;

public class SquidAstVisitorContextImpl<G extends Grammar>
extends SquidAstVisitorContext<G> {
    private final Deque<SourceCode> sourceCodeStack = new ArrayDeque<SourceCode>();
    private G grammar;
    private File file;
    private final SourceProject project;
    private CommentAnalyser commentAnalyser;

    public SquidAstVisitorContextImpl(SourceProject project) {
        if (project == null) {
            throw new IllegalArgumentException("project cannot be null.");
        }
        this.project = project;
        this.sourceCodeStack.push(project);
    }

    public void setGrammar(G grammar) {
        this.grammar = grammar;
    }

    public void setCommentAnalyser(CommentAnalyser commentAnalyser) {
        this.commentAnalyser = commentAnalyser;
    }

    @Override
    public CommentAnalyser getCommentAnalyser() {
        return this.commentAnalyser;
    }

    @Override
    public void addSourceCode(SourceCode child) {
        this.peekSourceCode().addChild(child);
        this.sourceCodeStack.push(child);
    }

    @Override
    public void popSourceCode() {
        this.sourceCodeStack.pop();
    }

    @Override
    public SourceCode peekSourceCode() {
        return this.sourceCodeStack.peek();
    }

    public void setFile(File file, MetricDef filesMetric) {
        this.popTillSourceProject();
        this.file = file;
        SourceFile sourceFile = new SourceFile(file.getAbsolutePath(), file.getName());
        this.addSourceCode(sourceFile);
        this.peekSourceCode().setMeasure(filesMetric, 1);
    }

    protected void popTillSourceProject() {
        while (!(this.peekSourceCode() instanceof SourceProject)) {
            this.popSourceCode();
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public SourceProject getProject() {
        return this.project;
    }

    @Override
    public G getGrammar() {
        return this.grammar;
    }

    @Override
    public void createFileViolation(CodeCheck check, String message, Object ... messageParameters) {
        this.createLineViolation(check, message, -1, messageParameters);
    }

    @Override
    public void createLineViolation(CodeCheck check, String message, AstNode node, Object ... messageParameters) {
        this.createLineViolation(check, message, node.getToken(), messageParameters);
    }

    @Override
    public void createLineViolation(CodeCheck check, String message, Token token, Object ... messageParameters) {
        this.createLineViolation(check, message, token.getLine(), messageParameters);
    }

    @Override
    public void createLineViolation(CodeCheck check, String message, int line, Object ... messageParameters) {
        CheckMessage checkMessage = new CheckMessage((Object)check, message, messageParameters);
        if (line > 0) {
            checkMessage.setLine(line);
        }
        this.log(checkMessage);
    }

    @Override
    public void log(CheckMessage message) {
        if (this.peekSourceCode() instanceof SourceFile) {
            this.peekSourceCode().log(message);
        } else if (this.peekSourceCode().getParent(SourceFile.class) != null) {
            this.peekSourceCode().getParent(SourceFile.class).log(message);
        } else {
            throw new IllegalStateException("Unable to log a check message on source code '" + (this.peekSourceCode() == null ? "[NULL]" : this.peekSourceCode().getKey()) + "'");
        }
    }
}

