/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.api;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.squidbridge.commonrules.internal.CommonRulesConstants;
import org.sonar.squidbridge.commonrules.internal.DefaultCommonRulesRepository;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@DependedUpon(value={"END_OF_VIOLATIONS_GENERATION"})
public abstract class CommonRulesDecorator
implements Decorator {
    private final FileSystem fs;
    private final String language;
    private final CheckFactory checkFactory;
    private final ResourcePerspectives perspectives;
    private Checks<CommonCheck> checks;

    public CommonRulesDecorator(String language, FileSystem fs, CheckFactory checkFactory, ResourcePerspectives perspectives) {
        this.language = language;
        this.fs = fs;
        this.checkFactory = checkFactory;
        this.perspectives = perspectives;
    }

    public String language() {
        return this.language;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.LINE_COVERAGE, CoreMetrics.COMMENT_LINES_DENSITY);
    }

    public boolean shouldExecuteOnProject(Project project) {
        if (!this.fs.hasFiles(this.fs.predicates().hasLanguage(this.language))) {
            return false;
        }
        this.checks = this.checkFactory.create(DefaultCommonRulesRepository.keyForLanguage(this.language));
        this.checks.addAnnotatedChecks(CommonRulesConstants.CLASSES);
        return !this.checks.all().isEmpty();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Language resourceLanguage = resource.getLanguage();
        if (ResourceUtils.isEntity((Resource)resource) && resourceLanguage != null && resourceLanguage.getKey().equals(this.language)) {
            for (CommonCheck check : this.checks.all()) {
                check.checkResource(resource, context, this.checks.ruleKey((Object)check), this.perspectives);
            }
        }
    }

    public String toString() {
        return "Common Rules for " + this.language;
    }
}

