/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="DuplicatedBlocks", name="Source files should not have any duplicated blocks", priority=Priority.MAJOR, tags={"pitfall"}, description="<p>An issue is created on a file as soon as there is at least one block of duplicated code on this file.</p>")
@SqaleSubCharacteristic(value="LOGIC_CHANGEABILITY")
@SqaleLinearWithOffsetRemediation(offset="10min", coeff="10min", effortToFixDescription="Number of duplicate blocks")
public class DuplicatedBlocksCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey rule, ResourcePerspectives perspectives) {
        double duplicatedBlocks = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.DUPLICATED_BLOCKS), (Double)0.0);
        if (duplicatedBlocks > 0.0) {
            this.createIssue(resource, rule, duplicatedBlocks, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double duplicatedBlocks, ResourcePerspectives perspectives) {
        this.createIssue(resource, perspectives, ruleKey, duplicatedBlocks, (int)duplicatedBlocks + " duplicated blocks of code must be removed.");
    }
}

