/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.rules;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;

@Beta
public class SqaleXmlLoader {
    private RulesDefinition.NewRepository repository;

    public SqaleXmlLoader(RulesDefinition.NewRepository repository) {
        this.repository = repository;
    }

    public static void load(RulesDefinition.NewRepository repository, String xmlResourcePath) {
        new SqaleXmlLoader(repository).loadXmlResource(xmlResourcePath);
    }

    public void loadXmlResource(String resourcePath) {
        InputStreamReader reader = this.reader(resourcePath);
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            this.processRoot(reader, inputFactory);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("SQALE XML is not valid: " + resourcePath, e);
        }
    }

    private void processRoot(InputStreamReader reader, SMInputFactory inputFactory) throws XMLStreamException {
        SMHierarchicCursor rootCursor = inputFactory.rootElementCursor((Reader)reader);
        rootCursor.advance();
        SMInputCursor charCursor = rootCursor.childElementCursor("chc");
        while (charCursor.getNext() != null) {
            SMInputCursor subCharCursor = charCursor.childElementCursor("chc");
            while (subCharCursor.getNext() != null) {
                this.processSubChar(subCharCursor);
            }
        }
    }

    private void processSubChar(SMInputCursor subCharCursor) throws XMLStreamException {
        String subCharName = null;
        SMInputCursor subCharChildCursor = subCharCursor.childElementCursor();
        while (subCharChildCursor.getNext() != null) {
            String childName = subCharChildCursor.getLocalName();
            if ("key".equals(childName)) {
                subCharName = subCharChildCursor.getElemStringValue();
            }
            if (!"chc".equals(childName)) continue;
            this.processRule(subCharName, subCharChildCursor);
        }
    }

    private void processRule(String subCharName, SMInputCursor ruleCursor) throws XMLStreamException {
        SMInputCursor ruleChildCursor = ruleCursor.childElementCursor();
        String ruleKey = null;
        String remediationFunction = null;
        String remediationFactor = null;
        String offset = null;
        while (ruleChildCursor.getNext() != null) {
            String childName = ruleChildCursor.getLocalName();
            if ("rule-key".equals(childName)) {
                ruleKey = ruleChildCursor.getElemStringValue();
            }
            if (!"prop".equals(childName)) continue;
            Map<String, String> propMap = this.childrenMap(ruleChildCursor.childElementCursor());
            String key = propMap.get("key");
            if ("remediationFunction".equals(key)) {
                remediationFunction = propMap.get("txt");
            }
            if ("offset".equals(key)) {
                offset = this.timeValue(propMap);
            }
            if (!"remediationFactor".equals(key)) continue;
            remediationFactor = this.timeValue(propMap);
        }
        RulesDefinition.NewRule rule = this.repository.rule(ruleKey);
        if (rule != null) {
            rule.setDebtSubCharacteristic(subCharName);
            rule.setDebtRemediationFunction(this.remediationFunction(rule.debtRemediationFunctions(), remediationFunction, offset, remediationFactor));
        }
    }

    private String timeValue(Map<String, String> propMap) {
        String value;
        String timeUnit = propMap.get("txt");
        if ("mn".equals(timeUnit)) {
            timeUnit = "min";
        }
        if ((value = propMap.get("val")).indexOf(46) > -1) {
            value = value.substring(0, value.indexOf(46));
        }
        return value + timeUnit;
    }

    private DebtRemediationFunction remediationFunction(RulesDefinition.DebtRemediationFunctions functions, String remediationFunction, String offset, String remediationFactor) {
        if ("CONSTANT_ISSUE".equalsIgnoreCase(remediationFunction)) {
            return functions.constantPerIssue(offset);
        }
        if ("LINEAR".equalsIgnoreCase(remediationFunction)) {
            return functions.linear(remediationFactor);
        }
        if ("LINEAR_OFFSET".equalsIgnoreCase(remediationFunction)) {
            return functions.linearWithOffset(remediationFactor, offset);
        }
        return null;
    }

    private Map<String, String> childrenMap(SMInputCursor cursor) throws XMLStreamException {
        HashMap<String, String> map = Maps.newHashMap();
        while (cursor.getNext() != null) {
            map.put(cursor.getLocalName(), cursor.getElemStringValue());
        }
        return map;
    }

    private InputStreamReader reader(String resourcePath) {
        URL url = Resources.getResource(SqaleXmlLoader.class, resourcePath);
        try {
            return Resources.newReaderSupplier(url, Charsets.UTF_8).getInput();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read " + resourcePath, e);
        }
    }
}

