/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.internal.vm.Machine;
import org.sonar.sslr.internal.vm.NativeExpression;

public class PatternExpression
extends NativeExpression
implements org.sonar.sslr.internal.matchers.Matcher {
    private final Matcher matcher;

    public PatternExpression(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
    }

    @Override
    public void execute(Machine machine) {
        boolean result;
        this.matcher.reset(machine);
        try {
            result = this.matcher.lookingAt();
        }
        catch (StackOverflowError e) {
            throw new GrammarException(e, "The regular expression '" + this.matcher.pattern().pattern() + "' has led to a stack overflow error." + " This error is certainly due to an inefficient use of alternations. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507");
        }
        if (result) {
            machine.createLeafNode(this, this.matcher.end());
            machine.jump(1);
        } else {
            machine.backtrack();
        }
    }

    public String toString() {
        return "Pattern " + this.matcher.pattern().pattern();
    }
}

