/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.php.generator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.codingmatters.value.objects.generation.Naming;
import org.codingmatters.value.objects.generation.preprocessor.PackagedValueSpec;
import org.codingmatters.value.objects.spec.AnonymousValueSpec;
import org.codingmatters.value.objects.spec.PropertyCardinality;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.PropertyTypeSpec;
import org.codingmatters.value.objects.spec.Spec;
import org.codingmatters.value.objects.spec.TypeKind;
import org.codingmatters.value.objects.spec.ValueSpec;

public class PhpSpecPreprocessor {
    private final Spec spec;
    private final String packageName;
    private final Naming naming = new Naming();

    public PhpSpecPreprocessor(Spec spec, String rootPackage) {
        this.spec = spec;
        this.packageName = rootPackage;
    }

    public List<PackagedValueSpec> packagedValueSpec() {
        LinkedList<PackagedValueSpec> result = new LinkedList<PackagedValueSpec>();
        for (ValueSpec valueSpec : this.spec.valueSpecs()) {
            result.addAll(this.preProcess(valueSpec, this.packageName));
        }
        return result;
    }

    private List<PackagedValueSpec> preProcess(ValueSpec valueSpec, String valuePackage) {
        ArrayList<PackagedValueSpec> valueSpecs = new ArrayList<PackagedValueSpec>();
        ValueSpec.Builder rootValueSpec = ValueSpec.valueSpec().name(PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()));
        for (PropertySpec propertySpec : valueSpec.propertySpecs()) {
            String propertyName = this.naming.property(new String[]{propertySpec.name()});
            if (propertySpec.typeSpec().typeKind() == TypeKind.EMBEDDED) {
                PropertySpec listType = propertySpec.typeSpec().embeddedValueSpec().propertySpecs().isEmpty() ? PropertySpec.property().build() : (PropertySpec)propertySpec.typeSpec().embeddedValueSpec().propertySpecs().get(0);
                if (this.isListOrSet(propertySpec)) {
                    this.processListProperty(valueSpec, valuePackage, rootValueSpec, propertySpec, listType);
                    continue;
                }
                if ("$value-object".equals(listType.name())) {
                    rootValueSpec.addProperty(PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().typeRef(listType.typeSpec().typeRef()).typeKind(TypeKind.EXTERNAL_VALUE_OBJECT).cardinality(PropertyCardinality.SINGLE)).build());
                    continue;
                }
                ValueSpec embeddedValueSpec = this.createEmbeddedValueSpec(propertySpec);
                String embeddedPackage = valuePackage + "." + valueSpec.name().toLowerCase();
                List<PackagedValueSpec> embeddedSpecs = this.preProcess(embeddedValueSpec, embeddedPackage);
                valueSpecs.addAll(embeddedSpecs);
                rootValueSpec.addProperty(this.createInSpecPropertyForEmbeddedType(propertySpec, embeddedPackage));
                continue;
            }
            if (this.isEnum(propertySpec)) {
                String enumName = PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()) + PhpSpecPreprocessor.capitalizedFirst(propertyName);
                rootValueSpec.addProperty(this.createEnumProperty(propertySpec.typeSpec().enumValues(), valuePackage + "." + valueSpec.name().toLowerCase() + "." + enumName, propertySpec.typeSpec().cardinality(), propertySpec.name()));
                continue;
            }
            if (propertySpec.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT) {
                rootValueSpec.addProperty(PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().cardinality(propertySpec.typeSpec().cardinality()).typeKind(TypeKind.IN_SPEC_VALUE_OBJECT).typeRef(this.packageName + "." + PhpSpecPreprocessor.capitalizedFirst(propertySpec.typeSpec().typeRef()))).build());
                continue;
            }
            if (propertySpec.typeSpec().typeRef().contains("date") || propertySpec.typeSpec().typeRef().contains("time")) {
                rootValueSpec.addProperty(PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().typeKind(TypeKind.EXTERNAL_VALUE_OBJECT).typeRef("io.flexio.utils.FlexDate").cardinality(propertySpec.typeSpec().cardinality())).build());
                continue;
            }
            rootValueSpec.addProperty(propertySpec);
        }
        valueSpecs.add(new PackagedValueSpec(valuePackage, rootValueSpec.build()));
        return valueSpecs;
    }

    private void processListProperty(ValueSpec valueSpec, String valuePackage, ValueSpec.Builder rootValueSpec, PropertySpec propertySpec, PropertySpec listType) {
        String name = this.naming.property(new String[]{propertySpec.name()});
        if (listType.typeSpec().typeKind() == TypeKind.ENUM) {
            String enumName = PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()) + PhpSpecPreprocessor.capitalizedFirst(name);
            rootValueSpec.addProperty(this.createEnumProperty(listType.typeSpec().enumValues(), valuePackage + "." + valueSpec.name().toLowerCase() + "." + enumName + "List", propertySpec.typeSpec().cardinality(), name));
        } else if (listType.typeSpec().typeKind() == TypeKind.EMBEDDED) {
            if ("$value-object".equals(((PropertySpec)listType.typeSpec().embeddedValueSpec().propertySpecs().get(0)).name())) {
                rootValueSpec.addProperty(PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().cardinality(PropertyCardinality.LIST).typeKind(TypeKind.EXTERNAL_VALUE_OBJECT).typeRef(this.packageName + "." + valueSpec.name().toLowerCase() + "." + PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()) + PhpSpecPreprocessor.capitalizedFirst(name) + "List").embeddedValueSpec(AnonymousValueSpec.anonymousValueSpec().addProperty(PropertySpec.property().type(PropertyTypeSpec.type().typeRef(((PropertySpec)listType.typeSpec().embeddedValueSpec().propertySpecs().get(0)).typeSpec().typeRef())).build()).build())).build());
            }
        } else if (listType.typeSpec().typeKind() == TypeKind.IN_SPEC_VALUE_OBJECT) {
            PropertyTypeSpec.Builder elementType = PropertyTypeSpec.type().typeRef(this.packageName + "." + PhpSpecPreprocessor.capitalizedFirst(listType.typeSpec().typeRef()));
            AnonymousValueSpec listElementType = AnonymousValueSpec.anonymousValueSpec().addProperty(PropertySpec.property().type(elementType).build()).build();
            String listTypeName = PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()) + PhpSpecPreprocessor.capitalizedFirst(name) + "List";
            rootValueSpec.addProperty(PropertySpec.property().name(propertySpec.name()).type(new PropertyTypeSpec.Builder().cardinality(propertySpec.typeSpec().cardinality()).typeKind(listType.typeSpec().typeKind()).typeRef(this.packageName + "." + valueSpec.name().toLowerCase() + "." + listTypeName).embeddedValueSpec(listElementType)).build());
        } else {
            PropertyTypeSpec.Builder list = listType.typeSpec().typeRef().contains("date") || listType.typeSpec().typeRef().contains("time") ? PropertyTypeSpec.type().typeKind(TypeKind.EXTERNAL_VALUE_OBJECT).typeRef("io.flexio.utils.FlexDate") : PropertyTypeSpec.type().typeKind(listType.typeSpec().typeKind()).typeRef(listType.typeSpec().typeRef());
            AnonymousValueSpec listElementType = AnonymousValueSpec.anonymousValueSpec().addProperty(PropertySpec.property().type(list).build()).build();
            PropertySpec prop = PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().typeKind(TypeKind.EXTERNAL_VALUE_OBJECT).typeRef(valuePackage + "." + valueSpec.name().toLowerCase() + "." + PhpSpecPreprocessor.capitalizedFirst(valueSpec.name()) + PhpSpecPreprocessor.capitalizedFirst(name) + "List").cardinality(PropertyCardinality.LIST).embeddedValueSpec(listElementType)).build();
            rootValueSpec.addProperty(prop);
        }
    }

    private PropertySpec createEnumProperty(String[] enumValues, String typeRef, PropertyCardinality cardinality, String propName) {
        PropertyTypeSpec.Builder type = PropertyTypeSpec.type().typeRef(typeRef).typeKind(TypeKind.ENUM).cardinality(cardinality);
        if (enumValues != null) {
            type.enumValues(enumValues);
        }
        return PropertySpec.property().name(propName).type(type).build();
    }

    private boolean isEnum(PropertySpec propertySpec) {
        return propertySpec.typeSpec().typeKind() == TypeKind.ENUM;
    }

    private PropertySpec createInSpecPropertyForEmbeddedType(PropertySpec propertySpec, String embeddedPackage) {
        return PropertySpec.property().name(propertySpec.name()).type(PropertyTypeSpec.type().typeKind(TypeKind.IN_SPEC_VALUE_OBJECT).typeRef(embeddedPackage + "." + PhpSpecPreprocessor.capitalizedFirst(propertySpec.name())).cardinality(propertySpec.typeSpec().cardinality())).build();
    }

    private ValueSpec createEmbeddedValueSpec(PropertySpec propertySpec) {
        ValueSpec.Builder embeddedValueSpecBuilder = ValueSpec.valueSpec().name(propertySpec.name());
        for (PropertySpec embeddedPropSpec : propertySpec.typeSpec().embeddedValueSpec().propertySpecs()) {
            embeddedValueSpecBuilder.addProperty(embeddedPropSpec);
        }
        return embeddedValueSpecBuilder.build();
    }

    private boolean isListOrSet(PropertySpec propertySpec) {
        return propertySpec.typeSpec().cardinality() == PropertyCardinality.LIST || propertySpec.typeSpec().cardinality() == PropertyCardinality.SET;
    }

    private static String capitalizedFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String uncapitalizedFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }
}

