/*
 * Decompiled with CFR 0.152.
 */
package org.codingmatters.value.objects.php.generator;

import java.util.Locale;
import org.codingmatters.value.objects.generation.Naming;
import org.codingmatters.value.objects.generation.preprocessor.PackagedValueSpec;
import org.codingmatters.value.objects.php.phpmodel.PhpMethod;
import org.codingmatters.value.objects.php.phpmodel.PhpPackagedValueSpec;
import org.codingmatters.value.objects.php.phpmodel.PhpParameter;
import org.codingmatters.value.objects.php.phpmodel.PhpPropertySpec;
import org.codingmatters.value.objects.spec.PropertySpec;
import org.codingmatters.value.objects.spec.TypeKind;

public class PhpModelParser {
    private final Naming naming = new Naming();

    public PhpPackagedValueSpec parseValueSpec(PackagedValueSpec valueSpec) {
        return this.getDummyPhpClass(valueSpec);
    }

    public boolean needToBeGenerated(PackagedValueSpec valueSpec) {
        return valueSpec.valueSpec().propertySpecs().size() != 1 || !((PropertySpec)valueSpec.valueSpec().propertySpecs().get(0)).name().equals("$value-object");
    }

    private PhpPackagedValueSpec getDummyPhpClass(PackagedValueSpec valueSpec) {
        PhpPackagedValueSpec phpPackagedValueSpec = new PhpPackagedValueSpec(valueSpec.packagename(), valueSpec.valueSpec().name());
        for (PropertySpec propertySpec : valueSpec.valueSpec().propertySpecs()) {
            PhpPropertySpec property = new PhpPropertySpec(propertySpec.typeSpec(), this.naming.property(new String[]{propertySpec.name()}), propertySpec.name());
            phpPackagedValueSpec.addProperty(property);
            phpPackagedValueSpec.addMethod(this.createGetter(propertySpec));
            phpPackagedValueSpec.addMethod(this.createSetter(propertySpec, this.firstLetterUpperCase(valueSpec.valueSpec().name())));
        }
        return phpPackagedValueSpec;
    }

    private PhpMethod createSetter(PropertySpec propertySpec, String returnType) {
        String propertyName = this.naming.property(new String[]{propertySpec.name()});
        PhpMethod phpMethod = new PhpMethod("with" + this.firstLetterUpperCase(propertyName));
        String type = propertySpec.typeSpec().typeKind() == TypeKind.JAVA_TYPE ? propertySpec.typeSpec().typeRef() : (propertySpec.typeSpec().typeRef() != null ? "\\" + propertySpec.typeSpec().typeRef().replace(".", "\\") : "");
        phpMethod.addParameters(new PhpParameter(propertyName, type));
        phpMethod.addInstruction("$this->" + propertyName + " = $" + propertyName);
        phpMethod.addInstruction("return $this");
        phpMethod.returnType(returnType);
        return phpMethod;
    }

    private PhpMethod createGetter(PropertySpec propertySpec) {
        String propertyName = this.naming.property(new String[]{propertySpec.name()});
        PhpMethod phpMethod = new PhpMethod(propertyName);
        phpMethod.addInstruction("return $this->" + propertyName);
        String type = propertySpec.typeSpec().typeKind() == TypeKind.JAVA_TYPE ? propertySpec.typeSpec().typeRef() : (propertySpec.typeSpec().typeRef() != null ? "\\" + propertySpec.typeSpec().typeRef().replace(".", "\\") : "");
        phpMethod.returnType(type);
        return phpMethod;
    }

    private String firstLetterUpperCase(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

