/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.scripting.secure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.flowable.engine.cfg.AbstractProcessEngineConfigurator;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.scripting.secure.behavior.SecureJavascriptTaskParseHandler;
import org.flowable.scripting.secure.impl.SecureScriptClassShutter;
import org.flowable.scripting.secure.impl.SecureScriptContextFactory;
import org.mozilla.javascript.ContextFactory;

public class SecureJavascriptConfigurator
extends AbstractProcessEngineConfigurator {
    public static SecureScriptContextFactory secureScriptContextFactory;
    public static SecureScriptClassShutter secureScriptClassShutter;
    protected boolean enableClassWhiteListing;
    protected Set<String> whiteListedClasses;
    protected long maxScriptExecutionTime = -1L;
    protected int maxStackDepth = -1;
    protected long maxMemoryUsed = -1L;
    protected int nrOfInstructionsBeforeStateCheckCallback = 100;
    protected int scriptOptimizationLevel = -1;

    public void beforeInit(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ArrayList<SecureJavascriptTaskParseHandler> customDefaultBpmnParseHandlers;
        if (secureScriptContextFactory == null) {
            this.initSecureScriptContextFactory();
        }
        if ((customDefaultBpmnParseHandlers = processEngineConfiguration.getCustomDefaultBpmnParseHandlers()) == null) {
            customDefaultBpmnParseHandlers = new ArrayList<SecureJavascriptTaskParseHandler>();
            processEngineConfiguration.setCustomDefaultBpmnParseHandlers(customDefaultBpmnParseHandlers);
        }
        customDefaultBpmnParseHandlers.add(new SecureJavascriptTaskParseHandler());
    }

    protected synchronized void initSecureScriptContextFactory() {
        if (secureScriptContextFactory == null) {
            secureScriptContextFactory = new SecureScriptContextFactory();
            secureScriptContextFactory.setOptimizationLevel(this.getScriptOptimizationLevel());
            if (this.isEnableClassWhiteListing() || this.getWhiteListedClasses() != null) {
                secureScriptClassShutter = new SecureScriptClassShutter();
                if (this.getWhiteListedClasses() != null && this.getWhiteListedClasses().size() > 0) {
                    secureScriptClassShutter.setWhiteListedClasses(this.getWhiteListedClasses());
                }
                secureScriptContextFactory.setClassShutter(secureScriptClassShutter);
            }
            if (this.getMaxScriptExecutionTime() > 0L) {
                secureScriptContextFactory.setMaxScriptExecutionTime(this.getMaxScriptExecutionTime());
            }
            if (this.getMaxMemoryUsed() > 0L) {
                secureScriptContextFactory.setMaxMemoryUsed(this.getMaxMemoryUsed());
            }
            if (this.getMaxStackDepth() > 0) {
                secureScriptContextFactory.setMaxStackDepth(this.getMaxStackDepth());
            }
            if (this.getMaxScriptExecutionTime() > 0L || this.getMaxMemoryUsed() > 0L) {
                secureScriptContextFactory.setObserveInstructionCount(this.getNrOfInstructionsBeforeStateCheckCallback());
            }
            ContextFactory.initGlobal((ContextFactory)secureScriptContextFactory);
        }
    }

    public boolean isEnableClassWhiteListing() {
        return this.enableClassWhiteListing;
    }

    public SecureJavascriptConfigurator setEnableClassWhiteListing(boolean enableClassWhiteListing) {
        this.enableClassWhiteListing = enableClassWhiteListing;
        return this;
    }

    public Set<String> getWhiteListedClasses() {
        return this.whiteListedClasses;
    }

    public SecureJavascriptConfigurator setWhiteListedClasses(Set<String> whiteListedClasses) {
        this.whiteListedClasses = whiteListedClasses;
        return this;
    }

    public SecureJavascriptConfigurator addWhiteListedClass(String whiteListedClass) {
        if (this.whiteListedClasses == null) {
            this.whiteListedClasses = new HashSet<String>();
        }
        this.whiteListedClasses.add(whiteListedClass);
        return this;
    }

    public long getMaxScriptExecutionTime() {
        return this.maxScriptExecutionTime;
    }

    public SecureJavascriptConfigurator setMaxScriptExecutionTime(long maxScriptExecutionTime) {
        this.maxScriptExecutionTime = maxScriptExecutionTime;
        return this;
    }

    public int getNrOfInstructionsBeforeStateCheckCallback() {
        return this.nrOfInstructionsBeforeStateCheckCallback;
    }

    public SecureJavascriptConfigurator setNrOfInstructionsBeforeStateCheckCallback(int nrOfInstructionsBeforeStateCheckCallback) {
        this.nrOfInstructionsBeforeStateCheckCallback = nrOfInstructionsBeforeStateCheckCallback;
        return this;
    }

    public int getMaxStackDepth() {
        return this.maxStackDepth;
    }

    public SecureJavascriptConfigurator setMaxStackDepth(int maxStackDepth) {
        this.maxStackDepth = maxStackDepth;
        return this;
    }

    public long getMaxMemoryUsed() {
        return this.maxMemoryUsed;
    }

    public SecureJavascriptConfigurator setMaxMemoryUsed(long maxMemoryUsed) {
        this.maxMemoryUsed = maxMemoryUsed;
        return this;
    }

    public int getScriptOptimizationLevel() {
        return this.scriptOptimizationLevel;
    }

    public SecureJavascriptConfigurator setScriptOptimizationLevel(int scriptOptimizationLevel) {
        this.scriptOptimizationLevel = scriptOptimizationLevel;
        return this;
    }

    public SecureScriptContextFactory getSecureScriptContextFactory() {
        return secureScriptContextFactory;
    }

    public static SecureScriptClassShutter getSecureScriptClassShutter() {
        return secureScriptClassShutter;
    }
}

