/*
 * Decompiled with CFR 0.152.
 */
package fj.test;

import fj.F;
import fj.data.Option;
import java.util.Random;

public final class Rand {
    private final F<Option<Long>, F<Integer, F<Integer, Integer>>> f;
    private final F<Option<Long>, F<Double, F<Double, Double>>> g;
    private final F<Long, Rand> onReseed;
    public static final Rand standard = Rand.createStandard(new Random());

    private Rand(F<Option<Long>, F<Integer, F<Integer, Integer>>> f, F<Option<Long>, F<Double, F<Double, Double>>> g, F<Long, Rand> onReseed) {
        this.f = f;
        this.g = g;
        this.onReseed = onReseed;
    }

    public int choose(long seed, int from, int to) {
        return (Integer)((F)((F)this.f.f((Object)Option.some((Object)seed))).f((Object)from)).f((Object)to);
    }

    public int choose(int from, int to) {
        return (Integer)((F)((F)this.f.f((Object)Option.none())).f((Object)from)).f((Object)to);
    }

    public long choose(long from, long to) {
        return ((Double)((F)((F)this.g.f((Object)Option.none())).f((Object)from)).f((Object)to)).longValue();
    }

    public double choose(long seed, double from, double to) {
        return (Double)((F)((F)this.g.f((Object)Option.some((Object)seed))).f((Object)from)).f((Object)to);
    }

    public double choose(double from, double to) {
        return (Double)((F)((F)this.g.f((Object)Option.none())).f((Object)from)).f((Object)to);
    }

    public Rand reseed(long seed) {
        return (Rand)this.onReseed.f((Object)seed);
    }

    public static Rand rand(F<Option<Long>, F<Integer, F<Integer, Integer>>> f, F<Option<Long>, F<Double, F<Double, Double>>> g, F<Long, Rand> onReseed) {
        return new Rand(f, g, onReseed);
    }

    private static Rand createStandard(Random defaultRandom) {
        return Rand.rand((F<Option<Long>, F<Integer, F<Integer, Integer>>>)((F)optSeed -> from -> to -> Rand.standardChooseInt((Random)optSeed.option(() -> defaultRandom, Random::new), from, to)), (F<Option<Long>, F<Double, F<Double, Double>>>)((F)optSeed -> from -> to -> Rand.standardChooseDbl((Random)optSeed.option(() -> defaultRandom, Random::new), from, to)), (F<Long, Rand>)((F)newSeed -> Rand.createStandard(new Random((long)newSeed))));
    }

    private static int standardChooseInt(Random random, int from, int to) {
        int result;
        if (from != to) {
            int min = Math.min(from, to);
            int max = Math.max(from, to);
            long range = 1L + (long)max - (long)min;
            long bound = Long.MAX_VALUE - Long.MAX_VALUE % range;
            long r = random.nextLong() & Long.MAX_VALUE;
            while (r >= bound) {
                r = random.nextLong() & Long.MAX_VALUE;
            }
            result = (int)(r % range + (long)min);
        } else {
            result = from;
        }
        return result;
    }

    private static double standardChooseDbl(Random random, double from, double to) {
        double min = Math.min(from, to);
        double max = Math.max(from, to);
        return (max - min) * random.nextDouble() + min;
    }
}

