/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F1Functions;
import fj.F2;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P2;
import fj.Show;
import fj.data.Conversions;
import fj.data.List;
import fj.data.Option;
import java.util.Collection;
import java.util.Iterator;

public final class NonEmptyList<A>
implements Iterable<A> {
    private final A head;
    private final List<A> tail;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public A head() {
        return this.head;
    }

    public List<A> tail() {
        return this.tail;
    }

    private NonEmptyList(A head, List<A> tail) {
        this.head = head;
        this.tail = tail;
    }

    public NonEmptyList<A> cons(A a) {
        return NonEmptyList.nel(a, this.tail.cons(this.head));
    }

    public NonEmptyList<A> snoc(A a) {
        return NonEmptyList.nel(this.head, this.tail.snoc(a));
    }

    public int length() {
        return 1 + this.tail.length();
    }

    public NonEmptyList<A> append(List<A> as) {
        return NonEmptyList.nel(this.head, this.tail.append(as));
    }

    public NonEmptyList<A> append(NonEmptyList<A> as) {
        List.Buffer<A> b = new List.Buffer<A>();
        b.append(this.tail);
        b.snoc(as.head);
        b.append(as.tail);
        List bb = b.toList();
        return NonEmptyList.nel(this.head, bb);
    }

    public final A foldRight1(F<A, F<A, A>> f) {
        return this.reverse().foldLeft1(Function.flip(f));
    }

    public final A foldRight1(F2<A, A, A> f) {
        return this.reverse().foldLeft1(Function.flip(f));
    }

    public final A foldLeft1(F<A, F<A, A>> f) {
        return this.foldLeft1(Function.uncurryF2(f));
    }

    public final A foldLeft1(F2<A, A, A> f) {
        A x = this.head;
        List<A> xs = this.tail;
        while (!xs.isEmpty()) {
            x = f.f(x, xs.head());
            xs = xs.tail();
        }
        return x;
    }

    public <B> NonEmptyList<B> map(F<A, B> f) {
        return NonEmptyList.nel(f.f(this.head), this.tail.map(f));
    }

    public <B> NonEmptyList<B> bind(F<A, NonEmptyList<B>> f) {
        List.Buffer b = new List.Buffer();
        NonEmptyList<B> p = f.f(this.head);
        b.snoc(p.head);
        b.append(p.tail);
        this.tail.foreachDoEffect(a -> {
            NonEmptyList p1 = (NonEmptyList)f.f(a);
            b.snoc(p1.head);
            b.append(p1.tail);
        });
        List bb = b.toList();
        return NonEmptyList.nel(bb.head(), bb.tail());
    }

    public NonEmptyList<NonEmptyList<A>> sublists() {
        return NonEmptyList.fromList(Option.somes(this.toList().toStream().substreams().map(F1Functions.o(NonEmptyList::fromList, Conversions.Stream_List())).toList())).some();
    }

    public NonEmptyList<NonEmptyList<A>> tails() {
        return NonEmptyList.fromList(Option.somes(this.toList().tails().map(NonEmptyList::fromList))).some();
    }

    public <B> NonEmptyList<B> mapTails(F<NonEmptyList<A>, B> f) {
        return this.tails().map(f);
    }

    public NonEmptyList<A> intersperse(A a) {
        List<A> list = this.toList().intersperse(a);
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public NonEmptyList<A> reverse() {
        List<A> list = this.toList().reverse();
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public NonEmptyList<A> sort(Ord<A> o) {
        List<A> list = this.toList().sort(o);
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public final A minimum(Ord<A> o) {
        return (A)this.foldLeft1(o::min);
    }

    public final A maximum(Ord<A> o) {
        return (A)this.foldLeft1(o::max);
    }

    public <B> NonEmptyList<P2<A, B>> zip(NonEmptyList<B> bs) {
        List<P2<A, B>> list = this.toList().zip(bs.toList());
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public NonEmptyList<P2<A, Integer>> zipIndex() {
        List<P2<A, Integer>> list = this.toList().zipIndex();
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public <B, C> NonEmptyList<C> zipWith(List<B> bs, F<A, F<B, C>> f) {
        List<C> list = this.toList().zipWith(bs, f);
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public <B, C> NonEmptyList<C> zipWith(List<B> bs, F2<A, B, C> f) {
        List<C> list = this.toList().zipWith(bs, f);
        return NonEmptyList.nel(list.head(), list.tail());
    }

    public static <A, B> P2<NonEmptyList<A>, NonEmptyList<B>> unzip(NonEmptyList<P2<A, B>> xs) {
        P2<List<A>, List<B>> p = List.unzip(xs.toList());
        return P.p(NonEmptyList.nel(p._1().head(), p._1().tail()), NonEmptyList.nel(p._2().head(), p._2().tail()));
    }

    public List<A> toList() {
        return this.tail.cons(this.head);
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    public static <A> F<NonEmptyList<A>, List<A>> toList_() {
        return NonEmptyList::toList;
    }

    public static <A> NonEmptyList<A> nel(A head, List<A> tail) {
        return new NonEmptyList<A>(head, tail);
    }

    @SafeVarargs
    public static <A> NonEmptyList<A> nel(A head, A ... tail) {
        return NonEmptyList.nel(head, List.list(tail));
    }

    public static <A> F<A, NonEmptyList<A>> nel() {
        return a -> NonEmptyList.nel(a, new Object[0]);
    }

    public static <A> Option<NonEmptyList<A>> fromList(List<A> as) {
        return as.isEmpty() ? Option.none() : Option.some(NonEmptyList.nel(as.head(), as.tail()));
    }

    public static <A> NonEmptyList<A> join(NonEmptyList<NonEmptyList<A>> o) {
        return o.bind(Function.identity());
    }

    public boolean equals(Object obj) {
        return Equal.equals0(NonEmptyList.class, this, obj, () -> Equal.nonEmptyListEqual(Equal.anyEqual()));
    }

    public int hashCode() {
        return Hash.nonEmptyListHash(Hash.anyHash()).hash(this);
    }

    public String toString() {
        return Show.nonEmptyListShow(Show.anyShow()).showS(this);
    }
}

