/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum GitlabAccessLevel {
    Guest(10),
    Reporter(20),
    Developer(30),
    Master(40),
    Owner(50);

    public final int accessValue;

    private GitlabAccessLevel(int accessValue) {
        this.accessValue = accessValue;
    }

    @JsonCreator
    public static GitlabAccessLevel fromAccessValue(int accessValue) throws IllegalArgumentException {
        for (GitlabAccessLevel gitlabAccessLevel : GitlabAccessLevel.values()) {
            if (gitlabAccessLevel.accessValue != accessValue) continue;
            return gitlabAccessLevel;
        }
        throw new IllegalArgumentException("No GitLab Access Level enum constant with access value: " + accessValue);
    }
}

