/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SSLContextUtil;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue997Test {
    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_Client127_CheckActive() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("127.0.0.1", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), "HTTPS");
        Assert.assertFalse((boolean)client.onOpen);
        Assert.assertTrue((boolean)client.onSSLError);
    }

    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_Client127_CheckInactive() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("127.0.0.1", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), "");
        Assert.assertTrue((boolean)client.onOpen);
        Assert.assertFalse((boolean)client.onSSLError);
    }

    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_Client127_CheckDefault() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("127.0.0.1", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), null);
        Assert.assertFalse((boolean)client.onOpen);
        Assert.assertTrue((boolean)client.onSSLError);
    }

    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_ClientLocalhost_CheckActive() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("localhost", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), "HTTPS");
        Assert.assertTrue((boolean)client.onOpen);
        Assert.assertFalse((boolean)client.onSSLError);
    }

    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_ClientLocalhost_CheckInactive() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("localhost", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), "");
        Assert.assertTrue((boolean)client.onOpen);
        Assert.assertFalse((boolean)client.onSSLError);
    }

    @Test(timeout=2000L)
    public void test_localServer_ServerLocalhost_ClientLocalhost_CheckDefault() throws CertificateException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, URISyntaxException, InterruptedException {
        SSLWebSocketClient client = this.testIssueWithLocalServer("localhost", SocketUtil.getAvailablePort(), SSLContextUtil.getLocalhostOnlyContext(), SSLContextUtil.getLocalhostOnlyContext(), null);
        Assert.assertTrue((boolean)client.onOpen);
        Assert.assertFalse((boolean)client.onSSLError);
    }

    public SSLWebSocketClient testIssueWithLocalServer(String address, int port, SSLContext serverContext, SSLContext clientContext, String endpointIdentificationAlgorithm) throws IOException, URISyntaxException, InterruptedException {
        CountDownLatch countServerDownLatch = new CountDownLatch(1);
        SSLWebSocketClient client = new SSLWebSocketClient(address, port, endpointIdentificationAlgorithm);
        SSLWebSocketServer server = new SSLWebSocketServer(port, countServerDownLatch);
        server.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(serverContext));
        if (clientContext != null) {
            client.setSocketFactory(clientContext.getSocketFactory());
        }
        server.start();
        countServerDownLatch.await();
        client.connectBlocking(1L, TimeUnit.SECONDS);
        return client;
    }

    private static class SSLWebSocketServer
    extends WebSocketServer {
        private final CountDownLatch countServerDownLatch;

        public SSLWebSocketServer(int port, CountDownLatch countServerDownLatch) {
            super(new InetSocketAddress(port));
            this.countServerDownLatch = countServerDownLatch;
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        public void onStart() {
            this.countServerDownLatch.countDown();
        }
    }

    private static class SSLWebSocketClient
    extends WebSocketClient {
        private final String endpointIdentificationAlgorithm;
        public boolean onSSLError = false;
        public boolean onOpen = false;

        public SSLWebSocketClient(String address, int port, String endpointIdentificationAlgorithm) throws URISyntaxException {
            super(new URI("wss://" + address + ':' + port));
            this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
        }

        public void onOpen(ServerHandshake handshakedata) {
            this.onOpen = true;
        }

        public void onMessage(String message) {
        }

        public void onClose(int code, String reason, boolean remote) {
        }

        public void onError(Exception ex) {
            if (ex instanceof SSLHandshakeException) {
                this.onSSLError = true;
            }
        }

        protected void onSetSSLParameters(SSLParameters sslParameters) {
            if (this.endpointIdentificationAlgorithm != null) {
                sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            }
        }
    }
}

