/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.mixin.EnabledAccessor;

public class Operation
extends AbstractOperand<Boolean>
implements EnabledAccessor {
    private String _operation;

    public Operation(String string, String string2, String string3) {
        super(Boolean.class, string2, string3);
        if (string == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        if (string.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()) | string.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + string + "\" must not start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._operation = string;
    }

    public Operation(String string, String string2) {
        super(Boolean.class, null, string2);
        if (string == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        if (string.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()) | string.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + string + "\" must not start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._operation = string;
    }

    @Override
    public List<Operand<Boolean>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        boolean bl;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.getOperation().equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            ArrayList<Operand<Boolean>> arrayList = new ArrayList<Operand<Boolean>>();
            arrayList.add(this);
            this.setArgs(new String[]{this.getOperation()});
            this.setValue(true);
            return arrayList;
        }
        throw new UnknownArgsException(stringArray, "The operation \"" + this.getOperation() + "\" was found in the command line arguments.");
    }

    public String getOperation() {
        return this._operation;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2) {
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        return string + this.getOperation() + (String)(this.getAlias() != null ? " " + CliUtility.toParameterSpec(this) : "") + string2;
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOperation());
        stringBuilder.append(":=");
        if (this.getValue() != null) {
            stringBuilder.append(((Boolean)this.getValue()).toString());
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEnabled() {
        Boolean bl = (Boolean)this.getValue();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    @Override
    protected Boolean toValue(String string) throws ParseArgsException {
        throw new UnsupportedOperationException("*** NOT REQUIRED BY THIS IMPLEMENTATION ***");
    }
}

