/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Condition;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionalCondition;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testParser1() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser2() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        OptionalCondition theOptional = new OptionalCondition(new Syntaxable[]{theXor});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theOptional, theFile});
        String[] args = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        if (IS_LOG_TESTS) {
            System.out.println(theAnd.toUsage());
        }
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser3() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser4() throws AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser5() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser6() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser7() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser8() {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theDelete, theAdd});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theOperand, theXor, theFromFile, theToFile});
        List theList = theAnd.toOperands();
        Collections.sort(theList);
        this.doLogOperands(theList);
    }

    @Test
    public void testParser9() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theCreate = new Flag("-c", null, null, "Creates the specified file");
        OrCondition theOrCondition = new OrCondition(new Syntaxable[]{theAdd, theCreate});
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theOrCondition, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOption theFromFile = new StringOption("-f", "--from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption theToFile = new StringOption("-t", "--to", "to", "The destination file to be processed");
        Flag theAddFile = new Flag("-a", "--add", "add", "Add the specified file");
        Flag theCreateFile = new Flag("-c", "--create", "create", "Creates the specified file");
        OrCondition theOrCondition = new OrCondition(new Syntaxable[]{theAddFile, theCreateFile});
        Flag theDeleteFile = new Flag("-d", "--delete", "delete", "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theOrCondition, theDeleteFile});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        if (IS_LOG_TESTS) {
            System.out.println(theAnd.toUsage());
        }
        theArgsParser.evalArgs(args);
        String theFrom = (String)theAnd.get("from");
        String theTo = (String)theAnd.get("to");
        boolean theAdd = (Boolean)theAnd.get("add");
        boolean theCreate = (Boolean)theAnd.get("create");
        boolean theDelete = (Boolean)theAnd.get("delete");
        if (IS_LOG_TESTS) {
            System.out.println("From := " + theFrom);
        }
        if (IS_LOG_TESTS) {
            System.out.println("To := " + theTo);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Add := " + theAdd);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Create := " + theCreate);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Delete := " + theDelete);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)theFrom);
        Assertions.assertEquals((Object)"toFile", (Object)theTo);
        Assertions.assertTrue((boolean)theAdd);
        Assertions.assertFalse((boolean)theCreate);
        Assertions.assertFalse((boolean)theDelete);
    }

    @Test
    public void testArgsProperties() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        int i = 0;
        while (i < ARGS.length) {
            this.testArgs(i);
            ++i;
        }
    }

    @Test
    public void testProductionError() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption theFrequencyOpt = CliSugar.doubleOption((String)"-f", (String)"--frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption theSamplingRateOpt = CliSugar.intOption((String)"-s", (String)"--sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption theLengthOpt = CliSugar.doubleOption((String)"-l", (String)"--length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        Condition theRoot = CliSugar.and((Syntaxable[])new Syntaxable[]{theFrequencyOpt, CliSugar.optional((Syntaxable[])new Syntaxable[]{theLengthOpt, theSamplingRateOpt})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl(theRoot);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.withName("Waves").withTitle("~waves~").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theArgsParser.withBannerFont((Font)new FontImpl(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theArgsParser.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        theArgsParser.evalArgs(args);
    }

    @Disabled
    @Test
    public void testEdgeCase() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        this.testArgs(3);
    }

    @Test
    public void testArrayOption1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        int i = 0;
        while (i < ((String[])theArray.getValue()).length) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
            ++i;
        }
    }

    @Test
    public void testArrayOption2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 3);
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        int i = 0;
        while (i < ((String[])theArray.getValue()).length) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
            ++i;
        }
    }

    @Test
    public void testArrayOption6() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-t", "text1"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        int i = 0;
        while (i < ((String[])theArray.getValue()).length) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
            ++i;
        }
    }

    @Test
    public void testArrayOption7() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(theArray.toUsage());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        int i = 0;
        while (i < ((String[])theArray.getValue()).length) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
            ++i;
        }
    }

    @Test
    public void testOperation1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Syntaxable[]{new AndCondition(new Syntaxable[]{ls, verbose}), cd});
        String[] theArgs = new String[]{"ls", "--verbose"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theRoot);
        theArgsParser.evalArgs(theArgs);
        Assertions.assertTrue((boolean)ls.isEnabled());
        Assertions.assertTrue((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        theRoot.reset();
        theArgs = new String[]{"cd"};
        theArgsParser.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertTrue((boolean)cd.isEnabled());
    }

    private void testArgs(int i) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        ArgsParserImpl theArgsParser = new ArgsParserImpl();
        HashMap<String, String> theProperties = new HashMap<String, String>();
        List theOperands = theArgsParser.evalArgs(ARGS[i]);
        for (Operand eOperand : theOperands) {
            theProperties.put(eOperand.getAlias(), "" + eOperand.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("Line <" + i + ">:");
        }
        for (String eKey : theProperties.keySet()) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(String.valueOf(eKey) + " := " + (String)theProperties.get(eKey));
        }
        String[] theExcepcted = PROPERTIES[i];
        int j = 0;
        while (j < theExcepcted.length) {
            PropertyImpl eProperty = new PropertyImpl(theExcepcted[j]);
            if (((String)eProperty.getKey()).equals("null")) {
                eProperty = new PropertyImpl(null, (String)eProperty.getValue());
            }
            Assertions.assertEquals((Object)eProperty.getValue(), theProperties.get(eProperty.getKey()), (String)("Line <" + i + "> (" + eProperty.toString() + ")"));
            ++j;
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ArgsParser aArgsParser, String[] aArgs) {
        Condition theCondition = aArgsParser.getRootCondition();
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        aArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + theCondition.toUsage(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + theCondition.toUsage(SyntaxNotation.GNU_POSIX));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[COMMAND LINE ARGS]         " + new VerboseTextBuilder().withElements((Object[])aArgs).toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("[INTERNAL STATUS]           " + theCondition.toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(List<? extends Operand<?>> aOperands) {
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> eOperand : aOperands) {
            if (!IS_LOG_TESTS) continue;
            System.out.println("[OPERAND] " + eOperand.toSyntax(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }
}

