/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Flag;
import org.refcodes.cli.OptionalCondition;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class StackOverflowTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testParserStackOverflow1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOption r = new StringOption("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOption s = new StringOption("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperand arg1 = new StringOperand("arg1", "Your description for arg1");
        StringOperand arg2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand arg3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand arg4 = new StringOperand("arg4", "Your description for arg4");
        Flag test = new Flag(null, "--test", null, "Your description for test");
        StringOption a = new StringOption("-A", null, "opt3", "Your description for option A with argument opt3");
        AndCondition theRoot = new AndCondition(new Syntaxable[]{r, s, a, arg1, arg2, arg3, arg4, test});
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theRoot);
        theArgsParser.withName("MyProgramm");
        theArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        theArgsParser.printUsage();
        theArgsParser.printSeparatorLn();
        theArgsParser.printOptions();
        theArgsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "--test", "-A", "AAAAA"});
        if (IS_LOG_TESTS) {
            System.out.println("r    :=" + (String)r.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("S    :=" + (String)s.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg1 :=" + (String)arg1.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg2 :=" + (String)arg2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg3 :=" + (String)arg3.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg4 :=" + (String)arg4.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("test :=" + test.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("A    :=" + (String)a.getValue());
        }
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)true);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOption r = new StringOption("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOption s = new StringOption("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperand arg1 = new StringOperand("arg1", "Your description for arg1");
        StringOperand arg2 = new StringOperand("arg2", "Your description for arg2");
        StringOperand arg3 = new StringOperand("arg3", "Your description for arg3");
        StringOperand arg4 = new StringOperand("arg4", "Your description for arg4");
        Flag test = new Flag(null, "--test", null, "Your description for test");
        StringOption a = new StringOption("-A", null, "opt3", "Your description for option A with argument opt3");
        AndCondition theRoot = new AndCondition(new Syntaxable[]{r, s, a, arg1, arg2, arg3, arg4, new OptionalCondition(new Syntaxable[]{test})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theRoot);
        theArgsParser.withName("MyProgramm");
        theArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        theArgsParser.printUsage();
        theArgsParser.printSeparatorLn();
        theArgsParser.printOptions();
        theArgsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "-A", "AAAAA"});
        if (IS_LOG_TESTS) {
            System.out.println("r    :=" + (String)r.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("S    :=" + (String)s.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg1 :=" + (String)arg1.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg2 :=" + (String)arg2.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg3 :=" + (String)arg3.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("arg4 :=" + (String)arg4.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("test :=" + test.getValue());
        }
        if (IS_LOG_TESTS) {
            System.out.println("A    :=" + (String)a.getValue());
        }
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)false);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }
}

